/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.groupware.contact.helpers.SpecialAlphanumSortContactComparator;
import com.openexchange.groupware.contact.helpers.UseCountGlobalFirstComparator;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.Order;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Comparator;
import java.util.Locale;

public class DefaultContactComparator
implements Comparator<Contact> {
    private static final ComparatorProvider USE_COUNT_COMPARATOR_PROVIDER = new ComparatorProvider(){
        private final UseCountGlobalFirstComparator comparator = new UseCountGlobalFirstComparator();

        @Override
        public Comparator<Contact> getComparator(Locale locale) {
            return this.comparator;
        }
    };
    private static final ComparatorProvider SPECIAL_COMPARATOR_PROVIDER = new ComparatorProvider(){

        @Override
        public Comparator<Contact> getComparator(Locale locale) {
            return new SpecialAlphanumSortContactComparator(locale);
        }
    };
    private static final TIntObjectHashMap<ComparatorProvider> SPECIAL_COMPARATORS = new TIntObjectHashMap<ComparatorProvider>(){
        {
            this.put(607, SPECIAL_COMPARATOR_PROVIDER);
            this.put(609, USE_COUNT_COMPARATOR_PROVIDER);
        }
    };
    private final int field;
    private final Order order;
    private final Locale locale;

    public DefaultContactComparator(int field, Order order, Locale locale) {
        this.field = field;
        this.order = order;
        this.locale = null == locale ? Locale.US : locale;
    }

    @Override
    public int compare(Contact o1, Contact o2) {
        if (this.field <= 0 || Order.NO_ORDER.equals((Object)this.order)) {
            return 0;
        }
        ComparatorProvider provider = (ComparatorProvider)SPECIAL_COMPARATORS.get(this.field);
        if (null != provider) {
            Comparator<Contact> specialComparator = provider.getComparator(this.locale);
            return Order.DESCENDING.equals((Object)this.order) ? -1 * specialComparator.compare(o1, o2) : specialComparator.compare(o1, o2);
        }
        Object v1 = o1.get(this.field);
        Object v2 = o2.get(this.field);
        return Order.DESCENDING.equals((Object)this.order) ? -1 * this.internalCompare(v1, v2) : this.internalCompare(v1, v2);
    }

    private int internalCompare(Object v1, Object v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null && v2 != null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (Comparable.class.isInstance(v1)) {
            return ((Comparable)v1).compareTo(v2);
        }
        throw new UnsupportedOperationException("Don't know how to compare two values of class " + v1.getClass().getName());
    }

    private static interface ComparatorProvider {
        public Comparator<Contact> getComparator(Locale var1);
    }
}

