/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContactDeleteListener
implements DeleteListener {
    private static Logger LOG = LoggerFactory.getLogger(ContactDeleteListener.class);
    private static String rightsSelectString = "SELECT co.intfield01,co.intfield02,co.intfield03,co.intfield04,co.fid,co.created_from,co.pflag,co.cid FROM prg_contacts AS co ";

    @Override
    public void deletePerformed(DeleteEvent deleteEvent, Connection readCon, Connection writeCon) throws OXException {
        if (deleteEvent.getType() == 1) {
            ContactDeleteListener.dropDListEntries("prg_dlist", "prg_contacts", deleteEvent.getId(), deleteEvent.getContext().getContextId(), writeCon);
            ContactDeleteListener.dropDListEntries("del_dlist", "del_contacts", deleteEvent.getId(), deleteEvent.getContext().getContextId(), writeCon);
            ContactDeleteListener.trashAllUserContacts(deleteEvent.getContext(), deleteEvent.getId(), deleteEvent.getSession(), readCon, writeCon);
        }
    }

    private static void dropDListEntries(String dlistTable, String contactTable, int userId, int contextId, Connection writeCon) throws OXException {
        String sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            sql = "SELECT d.intfield01, d.intfield02 FROM " + dlistTable + " AS d JOIN " + contactTable + " AS c ON d.cid = ? AND c.cid = ? AND d.intfield02 = c.intfield01 WHERE c.userId IS NOT NULL AND c.userId = ?";
            stmt = writeCon.prepareStatement(sql);
            stmt.setInt(1, contextId);
            stmt.setInt(2, contextId);
            stmt.setInt(3, userId);
            rs = stmt.executeQuery();
            ArrayList<int[]> l = new ArrayList<int[]>();
            while (rs.next()) {
                l.add(new int[]{rs.getInt(1), rs.getInt(2)});
            }
            DBUtils.closeSQLStuff(rs, stmt);
            sql = "DELETE FROM " + dlistTable + " WHERE cid = ? AND intfield01 = ? AND intfield02 = ?";
            stmt = writeCon.prepareStatement(sql);
            for (int[] arr : l) {
                stmt.setInt(1, contextId);
                stmt.setInt(2, arr[0]);
                stmt.setInt(3, arr[1]);
                stmt.addBatch();
            }
            stmt.executeBatch();
            DBUtils.closeSQLStuff(rs, stmt);
            TIntArrayList toDelete = new TIntArrayList();
            sql = "SELECT COUNT(intfield02) FROM " + dlistTable + " WHERE cid = ? AND intfield01 = ?";
            for (int[] arr : l) {
                int count;
                int dlistId = arr[0];
                stmt = writeCon.prepareStatement(sql);
                stmt.setInt(1, contextId);
                stmt.setInt(2, dlistId);
                rs = stmt.executeQuery();
                if (rs.next() && 0 == (count = rs.getInt(1))) {
                    toDelete.add(dlistId);
                }
                DBUtils.closeSQLStuff(rs, stmt);
            }
            if (!toDelete.isEmpty()) {
                sql = "DELETE FROM " + contactTable + " WHERE cid = ? AND intfield01 = ?";
                stmt = writeCon.prepareStatement(sql);
                for (int id : toDelete.toArray()) {
                    stmt.setInt(1, contextId);
                    stmt.setInt(2, id);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                DBUtils.closeSQLStuff(rs, stmt);
            }
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    private static void trashAllUserContacts(Context ct, int uid, Session so, Connection readcon, Connection writecon) throws OXException {
        ResultSet rs;
        Statement del;
        Statement stmt;
        block19: {
            stmt = null;
            del = null;
            rs = null;
            try {
                int contextId = so.getContextId();
                stmt = readcon.createStatement();
                del = writecon.createStatement();
                FolderObject contactFolder = null;
                rs = stmt.executeQuery(ContactDeleteListener.iFgetRightsSelectString(uid, contextId));
                int fid = 0;
                int oid = 0;
                int created_from = 0;
                boolean delete = false;
                int pflag = 0;
                EventClient ec = new EventClient(so);
                OXFolderAccess oxfs = null;
                while (rs.next()) {
                    delete = false;
                    oid = rs.getInt(1);
                    fid = rs.getInt(5);
                    created_from = rs.getInt(6);
                    pflag = rs.getInt(7);
                    if (rs.wasNull()) {
                        pflag = 0;
                    }
                    boolean folder_error = false;
                    try {
                        contactFolder = FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(fid, true, ct, readcon) : FolderObject.loadFolderObjectFromDB(fid, ct, readcon);
                        if (contactFolder.getModule() != 3) {
                            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)fid), Autoboxing.I((int)contextId), Autoboxing.I((int)uid));
                        }
                        if (contactFolder.getType() == 1) {
                            delete = true;
                        }
                    }
                    catch (Exception oe) {
                        LOG.warn("WARNING: During the delete process ''delete all contacts from one user'', a contact was found who has no folder.This contact will be modified and can be found in the administrator address book. Context={} Folder={} User={} Contact={}", new Object[]{contextId, fid, uid, oid});
                        folder_error = true;
                        delete = true;
                    }
                    if (folder_error && pflag == 0) {
                        try {
                            int mailadmin = ct.getMailadmin();
                            if (null == oxfs) {
                                oxfs = new OXFolderAccess(readcon, ct);
                            }
                            FolderObject xx = oxfs.getDefaultFolder(mailadmin, 3);
                            int admin_folder = xx.getObjectID();
                            ContactDeleteListener.iFgiveUserContacToAdmin(del, oid, admin_folder, ct);
                        }
                        catch (Exception oxee) {
                            LOG.error("ERROR: It was not possible to move this contact (without paren folder) to the admin address book!.This contact will be deleted.Context {} Folder {} User{} Contact{}", new Object[]{contextId, fid, uid, oid, oxee});
                            folder_error = false;
                        }
                    } else if (folder_error && pflag != 0) {
                        folder_error = false;
                    }
                    if (folder_error) continue;
                    ContactDeleteListener.iFtrashAllUserContacts(delete, del, contextId, oid, uid, rs, so, ct);
                    Contact co = new Contact();
                    try {
                        co.setCreatedBy(created_from);
                        co.setParentFolderID(fid);
                        co.setObjectID(oid);
                        ec.delete(co);
                    }
                    catch (Exception e) {
                        LOG.error("Unable to trigger delete event for contact delete: id=" + co.getObjectID() + " cid=" + co.getContextId(), (Throwable)e);
                    }
                }
                if (uid == ct.getMailadmin()) {
                    ContactDeleteListener.iFtrashAllUserContactsDeletedEntriesFromAdmin(del, contextId, uid);
                    break block19;
                }
                ContactDeleteListener.iFtrashAllUserContactsDeletedEntries(del, contextId, uid, ct);
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    DBUtils.closeSQLStuff(del);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        DBUtils.closeSQLStuff(del);
    }

    private static String iFgetRightsSelectString(int uid, int cid) {
        return rightsSelectString + " where created_from = " + uid + " AND cid = " + cid;
    }

    private static void iFgiveUserContacToAdmin(Statement smt, int oid, int admin_fid, Context ct) throws SQLException {
        StringBuilder tmp = new StringBuilder("UPDATE prg_contacts SET changed_from = ").append(ct.getMailadmin()).append(", created_from = ").append(ct.getMailadmin()).append(", changing_date = ").append(System.currentTimeMillis()).append(", fid = ").append(admin_fid).append(" WHERE intfield01 = ").append(oid).append(" and cid = ").append(ct.getContextId());
        smt.execute(tmp.toString());
    }

    private static void iFtrashAllUserContacts(boolean delete, Statement del, int cid, int oid, int uid, ResultSet rs, Session so, Context ctx) throws SQLException {
        StringBuilder tmp = new StringBuilder(256);
        if (delete) {
            tmp.append("DELETE from prg_dlist where intfield01 = ").append(oid).append(" AND cid = ").append(cid);
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts_linkage where (intfield01 = ").append(oid).append(" OR intfield02 = ").append(oid).append(") AND cid = ").append(cid);
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts_image where intfield01 = ").append(oid).append(" AND cid = ").append(cid);
            del.execute(tmp.toString());
            tmp.setLength(0);
            tmp.append("DELETE from prg_contacts WHERE cid = ").append(cid).append(" AND intfield01 = ").append(oid);
            del.execute(tmp.toString());
        } else {
            tmp.append("UPDATE prg_contacts SET changed_from = ").append(ctx.getMailadmin()).append(", created_from = ").append(ctx.getMailadmin()).append(", changing_date = ").append(System.currentTimeMillis()).append(" WHERE intfield01 = ").append(oid).append(" AND cid = ").append(cid);
            del.execute(tmp.toString());
        }
    }

    private static void iFtrashAllUserContactsDeletedEntriesFromAdmin(Statement del, int cid, int uid) throws SQLException {
        StringBuilder tmp = new StringBuilder("DELETE FROM del_contacts WHERE created_from = ").append(uid).append(" and cid = ").append(cid);
        del.execute(tmp.toString());
    }

    private static void iFtrashAllUserContactsDeletedEntries(Statement del, int cid, int uid, Context ct) throws SQLException {
        StringBuilder tmp = new StringBuilder("UPDATE del_contacts SET changed_from = ").append(ct.getMailadmin()).append(", created_from = ").append(ct.getMailadmin()).append(", changing_date = ").append(System.currentTimeMillis()).append(" WHERE created_from = ").append(uid).append(" and cid = ").append(cid);
        del.execute(tmp.toString());
    }
}

