/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.GroupWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="list", description="List groups", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An array with group identifiers.", responseDescription="An array of group objects as described in Group data.")
public final class ListAction
extends AbstractGroupAction {
    public ListAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        JSONArray jsonArray = (JSONArray)req.getData();
        Date timestamp = new Date(0L);
        Date lastModified = null;
        JSONArray jsonResponseArray = new JSONArray();
        GroupStorage groupStorage = GroupStorage.getInstance();
        GroupWriter groupWriter = new GroupWriter();
        for (int a = 0; a < jsonArray.length(); ++a) {
            JSONObject jData = jsonArray.getJSONObject(a);
            Group group = groupStorage.getGroup(DataParser.checkInt(jData, "id"), req.getSession().getContext());
            JSONObject jsonGroupObj = new JSONObject();
            groupWriter.writeGroup(group, jsonGroupObj);
            jsonResponseArray.put((Object)jsonGroupObj);
            lastModified = group.getLastModified();
            if (timestamp.getTime() >= lastModified.getTime()) continue;
            timestamp = lastModified;
        }
        return new AJAXRequestResult(jsonResponseArray, timestamp, "json");
    }
}

