/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.lock;

import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserLockManagement {
    private static final Logger LOG = LoggerFactory.getLogger(UserLockManagement.class);
    private static final UserLockManagement INSTANCE = new UserLockManagement();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, ReadWriteLock>> map = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, ReadWriteLock>>(32);

    public static UserLockManagement getInstance() {
        return INSTANCE;
    }

    private UserLockManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(Session session) {
        ConcurrentMap userMap = (ConcurrentMap)this.map.remove(session.getContextId());
        if (null != userMap) {
            userMap.remove(session.getUserId());
            LOG.debug("Cleaned folder locks for user {} in context {}", (Object)session.getUserId(), (Object)session.getContextId());
        }
    }

    public void dropFor(int contextId) {
        this.map.remove(contextId);
        LOG.debug("Cleaned folder locks for context {}", (Object)contextId);
    }

    public ReadWriteLock getFor(Session session) {
        return this.getFor(session.getUserId(), session.getContextId());
    }

    public ReadWriteLock getFor(int userId, int contextId) {
        ReadWriteLock readWriteLock;
        ConcurrentMap<Integer, ReentrantReadWriteLock> userMap = (ConcurrentHashMap<Integer, ReentrantReadWriteLock>)this.map.remove(contextId);
        if (null == userMap) {
            ConcurrentHashMap<Integer, ReentrantReadWriteLock> newUserMap = new ConcurrentHashMap<Integer, ReentrantReadWriteLock>(32);
            userMap = this.map.putIfAbsent(contextId, newUserMap);
            if (null == userMap) {
                userMap = newUserMap;
            }
        }
        if (null == (readWriteLock = (ReadWriteLock)userMap.get(userId))) {
            ReentrantReadWriteLock nrwl = new ReentrantReadWriteLock();
            readWriteLock = userMap.putIfAbsent(userId, nrwl);
            if (null == readWriteLock) {
                readWriteLock = nrwl;
            }
        }
        return readWriteLock;
    }

    public ReadWriteLock optFor(Session session) {
        ConcurrentMap userMap = (ConcurrentMap)this.map.remove(session.getContextId());
        if (null == userMap) {
            return null;
        }
        return (ReadWriteLock)userMap.get(session.getUserId());
    }
}

