/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json.actions;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.config.json.ConfigAJAXRequest;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigAction
implements AJAXActionService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigAction.class);
    private static final AJAXRequestResult RESULT_JSON_NULL = new AJAXRequestResult(JSONObject.NULL, "json");
    protected final ServiceLookup services;

    protected AbstractConfigAction(ServiceLookup services) {
        this.services = services;
    }

    protected <S> S getService(Class<? extends S> clazz) {
        return (S)this.services.getService(clazz);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            ConfigAJAXRequest ajaxRequest = new ConfigAJAXRequest(requestData, session);
            String sTimeZone = requestData.getParameter("timezone");
            if (null != sTimeZone) {
                ajaxRequest.setTimeZone(TimeZoneUtils.getTimeZone(sTimeZone));
            }
            return this.perform(ajaxRequest);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    protected abstract AJAXRequestResult perform(ConfigAJAXRequest var1) throws OXException, JSONException;

    protected static String getServletSpecificURI(HttpServletRequest req) {
        String uri;
        try {
            String characterEncoding = req.getCharacterEncoding();
            uri = AJAXUtility.decodeUrl(req.getRequestURI(), characterEncoding == null ? ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding) : characterEncoding);
        }
        catch (RuntimeException e) {
            LOG.error("Unsupported encoding", (Throwable)e);
            uri = req.getRequestURI();
        }
        String path = req.getContextPath() + req.getServletPath();
        int pos = uri.indexOf(path);
        if (pos != -1) {
            uri = uri.substring(pos + path.length());
        }
        return uri;
    }

    protected static AJAXRequestResult getJSONNullResult() {
        return RESULT_JSON_NULL;
    }
}

