/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.ElementAttributes;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(FolderCacheManager.class);
    private static volatile FolderCacheManager instance;
    private static final String REGION_NAME = "OXFolderCache";
    private volatile Cache folderCache;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock(true);

    private FolderCacheManager() throws OXException {
        this.initCache();
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static boolean isEnabled() {
        return OXFolderProperties.isEnableFolderCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initInstance() throws OXException {
        if (instance != null) return;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance != null) return;
            instance = new FolderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FolderCacheManager getInstance() throws OXException {
        if (!OXFolderProperties.isEnableFolderCache()) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        if (instance != null) return instance;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance != null) return instance;
            instance = new FolderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (instance == null) return;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance == null) return;
            instance = null;
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null == cacheService) return;
            try {
                cacheService.freeCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            return;
        }
    }

    public void initCache() throws OXException {
        if (this.folderCache != null) {
            return;
        }
        this.folderCache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(REGION_NAME);
    }

    public void releaseCache() throws OXException {
        Cache folderCache = this.folderCache;
        if (folderCache == null) {
            return;
        }
        folderCache.clear();
        this.folderCache = null;
    }

    CacheKey getCacheKey(int cid, int objectId) {
        return this.folderCache.newCacheKey(cid, objectId);
    }

    Lock getCacheLock() {
        return this.cacheLock.writeLock();
    }

    public void clearFor(final Context ctx, boolean async) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                int contextId = ctx.getContextId();
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    con = Database.get(contextId, false);
                    stmt = con.prepareStatement("SELECT fuid FROM oxfolder_tree WHERE cid=?");
                    stmt.setInt(1, contextId);
                    rs = stmt.executeQuery();
                    TIntHashSet folderIds = new TIntHashSet(1024);
                    while (rs.next()) {
                        folderIds.add(rs.getInt(1));
                    }
                    DBUtils.closeSQLStuff(rs, stmt);
                    stmt = con.prepareStatement("SELECT fuid FROM del_oxfolder_tree WHERE cid=?");
                    stmt.setInt(1, contextId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        folderIds.add(rs.getInt(1));
                    }
                    DBUtils.closeSQLStuff(rs, stmt);
                    rs = null;
                    stmt = null;
                    Database.back(contextId, false, con);
                    con = null;
                    FolderCacheManager.this.removeFolderObjects(folderIds.toArray(), ctx);
                }
                catch (Exception x) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (null != con) {
                        Database.back(contextId, false, con);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(rs, stmt);
                        if (null != con) {
                            Database.back(contextId, false, con);
                        }
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != con) {
                    Database.back(contextId, false, con);
                }
            }
        };
        if (async && ThreadPools.getThreadPool() != null) {
            ThreadPools.getThreadPool().submit(ThreadPools.task((Runnable)task));
        } else {
            task.run();
        }
    }

    public FolderObject getFolderObject(int objectId, boolean fromCache, Context ctx, Connection readCon) throws OXException {
        Object object;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create("foldercache.properties");
        }
        if (fromCache) {
            if (null != readCon) {
                this.putIfAbsentInternal(new LoadingFolderProvider(objectId, ctx, readCon), ctx, null);
            }
        } else {
            this.putFolderObject(this.loadFolderObjectInternal(objectId, ctx, readCon), ctx, true, null);
        }
        if ((object = folderCache.get((Serializable)this.getCacheKey(ctx.getContextId(), objectId))) instanceof FolderObject) {
            return ((FolderObject)object).clone();
        }
        FolderObject fo = this.loadFolderObjectInternal(objectId, ctx, readCon);
        this.putFolderObject(fo, ctx, false == fromCache, null);
        return fo.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject getFolderObject(int objectId, Context ctx) {
        FolderObject retval;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        Lock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            Object tmp = folderCache.get((Serializable)this.getCacheKey(ctx.getContextId(), objectId));
            retval = tmp instanceof FolderObject ? (FolderObject)tmp : null;
        }
        finally {
            readLock.unlock();
        }
        return null == retval ? retval : retval.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FolderObject> getTrimedFolderObjects(int[] objectIds, Context ctx) {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return Collections.emptyList();
        }
        Lock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            ArrayList<FolderObject> ret = new ArrayList<FolderObject>(objectIds.length);
            int contextId = ctx.getContextId();
            for (int objectId : objectIds) {
                Object tmp = folderCache.get((Serializable)this.getCacheKey(contextId, objectId));
                if (!(tmp instanceof FolderObject)) continue;
                ret.add(((FolderObject)tmp).clone());
            }
            ArrayList<FolderObject> arrayList = ret;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject loadFolderObject(int folderId, Context ctx, Connection readCon) throws OXException {
        Object object;
        CacheKey key = this.getCacheKey(ctx.getContextId(), folderId);
        Cache folderCache = this.folderCache;
        if (folderCache.isReplicated()) {
            Lock writeLock = this.cacheLock.writeLock();
            writeLock.lock();
            try {
                Object tmp = folderCache.get((Serializable)key);
                if (tmp instanceof FolderObject) {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(folderId)});
                            globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
                        }
                        catch (OXException e) {
                            LOG.warn("", (Throwable)e);
                        }
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        if (null != readCon) {
            this.putIfAbsent(this.loadFolderObjectInternal(folderId, ctx, readCon), ctx, null);
        }
        if ((object = folderCache.get((Serializable)key)) instanceof FolderObject) {
            return ((FolderObject)object).clone();
        }
        FolderObject fo = this.loadFolderObjectInternal(folderId, ctx, readCon);
        this.putFolderObject(fo, ctx, true, null);
        return fo.clone();
    }

    FolderObject loadFolderObjectInternal(int folderId, Context ctx, Connection readCon) throws OXException {
        if (folderId <= 0) {
            throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
        }
        return FolderObject.loadFolderObjectFromDB(folderId, ctx, readCon);
    }

    public FolderObject putIfAbsent(FolderObject folderObj, Context ctx, ElementAttributes elemAttribs) throws OXException {
        if (null == this.folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        if (!folderObj.containsObjectID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("id", Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        return this.putIfAbsentInternal(new InstanceFolderProvider(folderObj.clone()), ctx, elemAttribs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject putIfAbsentInternal(FolderProvider folderProvider, Context ctx, ElementAttributes elemAttribs) throws OXException {
        FolderObject retval;
        CacheKey key = this.getCacheKey(ctx.getContextId(), folderProvider.getObjectID());
        Lock writeLock = this.cacheLock.writeLock();
        writeLock.lock();
        try {
            Cache folderCache = this.folderCache;
            Object tmp = folderCache.get((Serializable)key);
            if (tmp instanceof FolderObject) {
                retval = (FolderObject)tmp;
            } else {
                Condition cond = null;
                if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                }
                if (elemAttribs == null || folderCache.isDistributed()) {
                    folderCache.put((Serializable)key, (Serializable)folderProvider.getFolderObject(), false);
                } else {
                    folderCache.put((Serializable)key, (Serializable)folderProvider.getFolderObject(), elemAttribs, false);
                }
                if (null != cond) {
                    cond.signalAll();
                }
                retval = null;
            }
        }
        finally {
            writeLock.unlock();
        }
        return null == retval ? retval : retval.clone();
    }

    public void putFolderObject(FolderObject folderObj, Context ctx) throws OXException {
        this.putFolderObject(folderObj, ctx, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFolderObject(FolderObject folderObj, Context ctx, boolean overwrite, ElementAttributes elemAttribs) throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (!folderObj.containsObjectID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("id", Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        if (null != elemAttribs) {
            elemAttribs.setIsLateral(false);
        }
        FolderObject clone = folderObj.clone();
        CacheKey key = this.getCacheKey(ctx.getContextId(), folderObj.getObjectID());
        Lock writeLock = this.cacheLock.writeLock();
        writeLock.lock();
        try {
            Object tmp = folderCache.get((Serializable)key);
            Condition cond = null;
            if (overwrite) {
                if (tmp instanceof FolderObject) {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(folderObj.getObjectID())});
                            globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
                        }
                        catch (OXException e) {
                            LOG.warn("", (Throwable)e);
                        }
                    }
                } else if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                }
            } else {
                if (tmp instanceof FolderObject) {
                    return;
                }
                if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                }
            }
            if (elemAttribs == null || folderCache.isDistributed()) {
                folderCache.put((Serializable)key, (Serializable)clone, false);
            } else {
                folderCache.put((Serializable)key, (Serializable)clone, elemAttribs, false);
            }
            if (null != cond) {
                cond.signalAll();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderObject(int folderId, Context ctx) throws OXException {
        CacheService cacheService;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (folderId > 0) {
            CacheKey cacheKey = this.getCacheKey(ctx.getContextId(), folderId);
            Lock writeLock = this.cacheLock.writeLock();
            writeLock.lock();
            try {
                Object tmp = folderCache.get((Serializable)cacheKey);
                if (!(tmp instanceof Condition)) {
                    folderCache.remove((Serializable)cacheKey);
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        if (null != (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(folderId)});
                globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderObjects(int[] folderIds, Context ctx) throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (folderIds == null || folderIds.length == 0) {
            return;
        }
        ArrayList<CacheKey> cacheKeys = new ArrayList<CacheKey>();
        for (int key : folderIds) {
            if (key <= 0) continue;
            cacheKeys.add(this.getCacheKey(ctx.getContextId(), key));
        }
        Lock writeLock = this.cacheLock.writeLock();
        writeLock.lock();
        try {
            for (CacheKey cacheKey : cacheKeys) {
                Object tmp = folderCache.get((Serializable)cacheKey);
                if (tmp instanceof Condition) continue;
                folderCache.remove((Serializable)cacheKey);
            }
        }
        finally {
            writeLock.unlock();
        }
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                for (int key : folderIds) {
                    CacheKey cacheKey = cacheService.newCacheKey(1, new String[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                    globalCache.removeFromGroup((Serializable)cacheKey, String.valueOf(ctx.getContextId()));
                }
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
        }
    }

    public void clearAll() throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        folderCache.clear();
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                globalCache.clear();
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
        }
    }

    public ElementAttributes getDefaultFolderObjectAttributes() throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        return folderCache.getDefaultElementAttributes();
    }

    private static final class LoadingFolderProvider
    implements FolderProvider {
        private final Connection readCon;
        private final int folderId;
        private final Context ctx;

        public LoadingFolderProvider(int folderId, Context ctx, Connection readCon) {
            this.folderId = folderId;
            this.ctx = ctx;
            this.readCon = readCon;
        }

        @Override
        public FolderObject getFolderObject() throws OXException {
            if (this.folderId <= 0) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(Autoboxing.I((int)this.folderId), Autoboxing.I((int)this.ctx.getContextId()));
            }
            return FolderObject.loadFolderObjectFromDB(this.folderId, this.ctx, this.readCon);
        }

        @Override
        public int getObjectID() {
            return this.folderId;
        }
    }

    private static final class InstanceFolderProvider
    implements FolderProvider {
        private final FolderObject folderObject;

        public InstanceFolderProvider(FolderObject folderObject) {
            this.folderObject = folderObject;
        }

        @Override
        public FolderObject getFolderObject() {
            return this.folderObject;
        }

        @Override
        public int getObjectID() {
            return this.folderObject.getObjectID();
        }
    }

    private static interface FolderProvider {
        public FolderObject getFolderObject() throws OXException;

        public int getObjectID();
    }
}

