/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class MultipleAdapter
implements MultipleHandler {
    private final AJAXActionServiceFactory factory;
    private final AtomicReference<AJAXRequestResult> result;
    private static final Pattern SPLIT_CSV = Pattern.compile("\\s*,\\s*");

    public MultipleAdapter(AJAXActionServiceFactory factory) {
        this.factory = factory;
        this.result = new AtomicReference();
    }

    public static AJAXRequestData parse(String module, String path, String action, JSONObject jsonObject, ServerSession session, boolean secure) throws JSONException {
        String parameter;
        AJAXRequestData request = new AJAXRequestData();
        request.setSecure(secure);
        if (jsonObject.hasAndNotNull("decorators") && null != (parameter = jsonObject.getString("decorators"))) {
            for (String id : SPLIT_CSV.split(parameter, 0)) {
                request.addDecoratorId(id.trim());
            }
        }
        request.setHostname(jsonObject.getString("__hostname"));
        request.setRoute(jsonObject.getString("__route"));
        request.setRemoteAddress(jsonObject.getString("__remoteAddress"));
        for (Map.Entry entry : jsonObject.entrySet()) {
            String name = (String)entry.getKey();
            if ("data".equals(name)) {
                request.setData(entry.getValue());
                continue;
            }
            Object value = entry.getValue();
            if (value == null || value == JSONObject.NULL) continue;
            request.putParameter(name, entry.getValue().toString());
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        request.setModule(module);
        request.setFormat("json");
        request.setAction(action);
        request.setServletRequestURI(path);
        request.setPathInfo(path);
        return request;
    }

    @Override
    public Object performRequest(String action, JSONObject jsonObject, ServerSession session, boolean secure) throws JSONException, OXException {
        AJAXRequestResult requestResult;
        AJAXActionService actionService = this.factory.createActionService(action);
        if (null == actionService) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
        }
        AJAXRequestData request = MultipleAdapter.parse("", "", action, jsonObject, session, secure);
        try {
            requestResult = actionService.perform(request, session);
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (null != request) {
                request.cleanUploads();
            }
        }
        this.result.set(requestResult);
        return requestResult.getResultObject();
    }

    @Override
    public Date getTimestamp() {
        AJAXRequestResult result = this.result.get();
        if (null == result) {
            return null;
        }
        Date timestamp = result.getTimestamp();
        return null == timestamp ? null : new Date(timestamp.getTime());
    }

    @Override
    public void close() {
        this.result.set(null);
    }

    @Override
    public Collection<OXException> getWarnings() {
        if (null == this.result.get()) {
            return Collections.emptySet();
        }
        return this.result.get().getWarnings();
    }
}

