/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.URLHelper;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONDocumentMetadata
implements DocumentMetadata {
    private static final long serialVersionUID = -5016635593135118691L;
    private static final URLHelper helper = new URLHelper();
    private final JSONObject jsonObject;
    private static final Logger LOG = LoggerFactory.getLogger(JSONDocumentMetadata.class);
    private static final String DEFAULT_MIMETYPE = "application/octet-stream";

    public JSONDocumentMetadata() {
        this.jsonObject = new JSONObject();
    }

    public JSONDocumentMetadata(String json) throws JSONException {
        String url;
        this.jsonObject = new JSONObject(json);
        if (this.jsonObject.has(Metadata.URL_LITERAL.getName()) && !"".equals((url = this.jsonObject.getString(Metadata.URL_LITERAL.getName())).trim())) {
            url = helper.process(url);
            this.jsonObject.put(Metadata.URL_LITERAL.getName(), (Object)url);
        }
    }

    @Override
    public String getProperty(String key) {
        if (Metadata.get(key) == null) {
            return this.jsonObject.optString(key);
        }
        return null;
    }

    @Override
    public Set<String> getPropertyNames() {
        return null;
    }

    @Override
    public Date getLastModified() {
        if (!this.jsonObject.has(Metadata.LAST_MODIFIED_LITERAL.getName())) {
            return null;
        }
        return new Date(this.jsonObject.optLong(Metadata.LAST_MODIFIED_LITERAL.getName()));
    }

    @Override
    public void setLastModified(Date now) {
        try {
            this.jsonObject.put(Metadata.LAST_MODIFIED_LITERAL.getName(), now.getTime());
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public Date getCreationDate() {
        if (!this.jsonObject.has(Metadata.CREATION_DATE_LITERAL.getName())) {
            return null;
        }
        return new Date(this.jsonObject.optLong(Metadata.CREATION_DATE_LITERAL.getName()));
    }

    @Override
    public void setCreationDate(Date creationDate) {
        try {
            this.jsonObject.put(Metadata.CREATION_DATE_LITERAL.getName(), creationDate.getTime());
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public int getModifiedBy() {
        if (!this.jsonObject.has(Metadata.MODIFIED_BY_LITERAL.getName())) {
            return -1;
        }
        return this.jsonObject.optInt(Metadata.MODIFIED_BY_LITERAL.getName());
    }

    @Override
    public void setModifiedBy(int lastEditor) {
        try {
            this.jsonObject.put(Metadata.MODIFIED_BY_LITERAL.getName(), lastEditor);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public long getFolderId() {
        if (!this.jsonObject.has(Metadata.FOLDER_ID_LITERAL.getName())) {
            return -1L;
        }
        return this.jsonObject.optLong(Metadata.FOLDER_ID_LITERAL.getName());
    }

    @Override
    public void setFolderId(long folderId) {
        try {
            this.jsonObject.put(Metadata.FOLDER_ID_LITERAL.getName(), folderId);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getTitle() {
        if (!this.jsonObject.has(Metadata.TITLE_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.TITLE_LITERAL.getName());
    }

    @Override
    public void setTitle(String title) {
        try {
            this.jsonObject.put(Metadata.TITLE_LITERAL.getName(), (Object)title);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public int getVersion() {
        if (!this.jsonObject.has(Metadata.VERSION_LITERAL.getName())) {
            return 0;
        }
        return this.jsonObject.optInt(Metadata.VERSION_LITERAL.getName());
    }

    @Override
    public void setVersion(int version2) {
        try {
            this.jsonObject.put(Metadata.VERSION_LITERAL.getName(), version2);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getContent() {
        return this.getDescription();
    }

    @Override
    public long getFileSize() {
        if (!this.jsonObject.has(Metadata.FILE_SIZE_LITERAL.getName())) {
            return -1L;
        }
        return this.jsonObject.optLong(Metadata.FILE_SIZE_LITERAL.getName());
    }

    @Override
    public void setFileSize(long length) {
        try {
            this.jsonObject.put(Metadata.FILE_SIZE_LITERAL.getName(), length);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getFileMIMEType() {
        if (!this.jsonObject.has(Metadata.FILE_MIMETYPE_LITERAL.getName())) {
            return DEFAULT_MIMETYPE;
        }
        return this.jsonObject.optString(Metadata.FILE_MIMETYPE_LITERAL.getName());
    }

    @Override
    public void setFileMIMEType(String type) {
        try {
            this.jsonObject.put(Metadata.FILE_MIMETYPE_LITERAL.getName(), (Object)type);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getFileName() {
        if (!this.jsonObject.has(Metadata.FILENAME_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.FILENAME_LITERAL.getName());
    }

    @Override
    public void setFileName(String fileName) {
        try {
            this.jsonObject.put(Metadata.FILENAME_LITERAL.getName(), (Object)fileName);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public int getId() {
        if (!this.jsonObject.has(Metadata.ID_LITERAL.getName())) {
            return -1;
        }
        return this.jsonObject.optInt(Metadata.ID_LITERAL.getName());
    }

    @Override
    public void setId(int id) {
        try {
            this.jsonObject.put(Metadata.ID_LITERAL.getName(), id);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getMeta() {
        JSONObject jMeta = this.jsonObject.optJSONObject(Metadata.META_LITERAL.getName());
        if (null == jMeta) {
            return null;
        }
        return jMeta.asMap();
    }

    @Override
    public void setMeta(Map<String, Object> properties) {
        if (null == properties || properties.isEmpty()) {
            this.jsonObject.remove(Metadata.META_LITERAL.getName());
        } else {
            try {
                this.jsonObject.put(Metadata.META_LITERAL.getName(), (Object)new JSONObject(properties));
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public int getCreatedBy() {
        if (!this.jsonObject.has(Metadata.CREATED_BY_LITERAL.getName())) {
            return -1;
        }
        return this.jsonObject.optInt(Metadata.CREATED_BY_LITERAL.getName());
    }

    @Override
    public void setCreatedBy(int creator) {
        try {
            this.jsonObject.put(Metadata.CREATED_BY_LITERAL.getName(), creator);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getDescription() {
        if (!this.jsonObject.has(Metadata.DESCRIPTION_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.DESCRIPTION_LITERAL.getName());
    }

    @Override
    public void setDescription(String description) {
        try {
            this.jsonObject.put(Metadata.DESCRIPTION_LITERAL.getName(), (Object)description);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getURL() {
        if (!this.jsonObject.has(Metadata.URL_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.URL_LITERAL.getName());
    }

    @Override
    public void setURL(String url) {
        try {
            this.jsonObject.put(Metadata.URL_LITERAL.getName(), (Object)url);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public long getSequenceNumber() {
        if (this.getLastModified() == null) {
            return 0L;
        }
        return this.getLastModified().getTime();
    }

    @Override
    public String getCategories() {
        if (!this.jsonObject.has(Metadata.CATEGORIES_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.CATEGORIES_LITERAL.getName());
    }

    @Override
    public void setCategories(String categories) {
        try {
            this.jsonObject.put(Metadata.CATEGORIES_LITERAL.getName(), (Object)categories);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public Date getLockedUntil() {
        if (!this.jsonObject.has(Metadata.LOCKED_UNTIL_LITERAL.getName())) {
            return null;
        }
        return new Date(this.jsonObject.optLong(Metadata.LOCKED_UNTIL_LITERAL.getName()));
    }

    @Override
    public void setLockedUntil(Date lockedUntil) {
        try {
            this.jsonObject.put(Metadata.LOCKED_UNTIL_LITERAL.getName(), (Object)lockedUntil);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getFileMD5Sum() {
        if (!this.jsonObject.has(Metadata.FILE_MD5SUM_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.FILE_MD5SUM_LITERAL.getName());
    }

    @Override
    public void setFileMD5Sum(String sum) {
        try {
            this.jsonObject.put(Metadata.FILE_MD5SUM_LITERAL.getName(), (Object)sum);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public int getColorLabel() {
        return this.jsonObject.optInt(Metadata.COLOR_LABEL_LITERAL.getName());
    }

    @Override
    public void setColorLabel(int color) {
        try {
            this.jsonObject.put(Metadata.COLOR_LABEL_LITERAL.getName(), color);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public boolean isCurrentVersion() {
        return this.jsonObject.optBoolean(Metadata.CURRENT_VERSION_LITERAL.getName());
    }

    @Override
    public void setIsCurrentVersion(boolean bool) {
        try {
            this.jsonObject.put(Metadata.CURRENT_VERSION_LITERAL.getName(), bool);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public String getVersionComment() {
        if (!this.jsonObject.has(Metadata.VERSION_COMMENT_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.VERSION_COMMENT_LITERAL.getName());
    }

    @Override
    public void setVersionComment(String string) {
        try {
            this.jsonObject.put(Metadata.VERSION_COMMENT_LITERAL.getName(), (Object)string);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public String toJSONString() {
        return this.jsonObject.toString();
    }

    @Override
    public String getFilestoreLocation() {
        if (!this.jsonObject.has(Metadata.FILESTORE_LOCATION_LITERAL.getName())) {
            return null;
        }
        return this.jsonObject.optString(Metadata.FILESTORE_LOCATION_LITERAL.getName());
    }

    @Override
    public void setFilestoreLocation(String string) {
        try {
            this.jsonObject.put(Metadata.FILESTORE_LOCATION_LITERAL.getName(), (Object)string);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public void setNumberOfVersions(int numberOfVersions) {
        try {
            this.jsonObject.put(Metadata.NUMBER_OF_VERSIONS_LITERAL.getName(), numberOfVersions);
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public int getNumberOfVersions() {
        if (this.jsonObject.has(Metadata.NUMBER_OF_VERSIONS_LITERAL.getName())) {
            return this.jsonObject.optInt(Metadata.NUMBER_OF_VERSIONS_LITERAL.getName());
        }
        return -1;
    }
}

