/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.openexchange.ajax.helper.ParamContainerExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ParamContainer {
    static final Pattern SPLIT = Pattern.compile(" *, *");
    public static final int NOT_FOUND = -9999;

    public static ParamContainer getInstance(HttpServletRequest req, EnumComponent component, HttpServletResponse resp) {
        return new HttpParamContainer(req, component, resp);
    }

    public static ParamContainer getInstance(JSONObject jo, EnumComponent component) {
        return new JSONParamContainer(jo, component);
    }

    public static ParamContainer getInstance(Map<String, String> map, EnumComponent component) {
        return new MapParamContainer(map, component);
    }

    public abstract String getStringParam(String var1) throws OXException;

    public abstract Set<String> getParameterNames();

    public abstract String checkStringParam(String var1) throws OXException;

    public abstract int getIntParam(String var1) throws OXException;

    public abstract int checkIntParam(String var1) throws OXException;

    public abstract long getLongParam(String var1) throws OXException;

    public abstract long checkLongParam(String var1) throws OXException;

    public abstract int[] getIntArrayParam(String var1) throws OXException;

    public abstract int[] checkIntArrayParam(String var1) throws OXException;

    public abstract Date getDateParam(String var1) throws OXException;

    public abstract Date checkDateParam(String var1) throws OXException;

    public abstract String getHeader(String var1);

    public abstract HttpServletResponse getHttpServletResponse();

    private static final class JSONParamContainer
    extends ParamContainer {
        private final JSONObject jo;
        private final EnumComponent component;

        public JSONParamContainer(JSONObject jo, EnumComponent component) {
            this.jo = jo;
            this.component = component;
        }

        @Override
        public Set<String> getParameterNames() {
            return this.jo.keySet();
        }

        @Override
        public Date checkDateParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return new Date(this.jo.getLong(paramName));
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public int[] checkIntArrayParam(String paramName) throws OXException {
            String[] tmp;
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                tmp = SPLIT.split(this.jo.getString(paramName), 0);
            }
            catch (JSONException e1) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
            int[] intArray = new int[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                try {
                    intArray[i] = Integer.parseInt(tmp[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
                }
            }
            return intArray;
        }

        @Override
        public int checkIntParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return this.jo.getInt(paramName);
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public long checkLongParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return this.jo.getLong(paramName);
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public String checkStringParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return this.jo.getString(paramName);
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public Date getDateParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                return null;
            }
            try {
                return new Date(this.jo.getLong(paramName));
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public String getHeader(String hdrName) {
            return null;
        }

        @Override
        public int[] getIntArrayParam(String paramName) throws OXException {
            String[] tmp;
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                return null;
            }
            try {
                tmp = SPLIT.split(this.jo.getString(paramName), 0);
            }
            catch (JSONException e1) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
            int[] intArray = new int[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                try {
                    intArray[i] = Integer.parseInt(tmp[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
                }
            }
            return intArray;
        }

        @Override
        public int getIntParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                return -9999;
            }
            try {
                return this.jo.getInt(paramName);
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public long getLongParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                return -9999L;
            }
            try {
                return this.jo.getLong(paramName);
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public String getStringParam(String paramName) throws OXException {
            if (!this.jo.has(paramName) || this.jo.isNull(paramName)) {
                return null;
            }
            try {
                return this.jo.getString(paramName);
            }
            catch (JSONException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(this.jo.opt(paramName), paramName);
            }
        }

        @Override
        public HttpServletResponse getHttpServletResponse() {
            return null;
        }
    }

    private static final class HttpParamContainer
    extends ParamContainer {
        private final HttpServletRequest req;
        private final EnumComponent component;
        private final HttpServletResponse resp;

        public HttpParamContainer(HttpServletRequest req, EnumComponent component, HttpServletResponse resp) {
            this.req = req;
            this.component = component;
            this.resp = resp;
        }

        @Override
        public Set<String> getParameterNames() {
            HashSet<String> ret = new HashSet<String>();
            Enumeration enumeration = this.req.getParameterNames();
            while (enumeration.hasMoreElements()) {
                ret.add((String)enumeration.nextElement());
            }
            return ret;
        }

        @Override
        public Date checkDateParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return new Date(Long.parseLong(tmp));
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public int[] checkIntArrayParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            String[] sa = SPLIT.split(tmp, 0);
            int[] intArray = new int[sa.length];
            for (int a = 0; a < sa.length; ++a) {
                try {
                    intArray[a] = Integer.parseInt(sa[a]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
                }
            }
            return intArray;
        }

        @Override
        public long checkLongParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public int checkIntParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public String checkStringParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            return tmp;
        }

        @Override
        public Date getDateParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                return null;
            }
            try {
                return new Date(Long.parseLong(tmp));
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public String getHeader(String hdrName) {
            return this.req.getHeader(hdrName);
        }

        @Override
        public int[] getIntArrayParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                return null;
            }
            String[] sa = SPLIT.split(tmp, 0);
            int[] intArray = new int[sa.length];
            for (int a = 0; a < sa.length; ++a) {
                try {
                    intArray[a] = Integer.parseInt(sa[a]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
                }
            }
            return intArray;
        }

        @Override
        public int getIntParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                return -9999;
            }
            try {
                return Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public long getLongParam(String paramName) throws OXException {
            String tmp = this.req.getParameter(paramName);
            if (tmp == null) {
                return -9999L;
            }
            try {
                return Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public String getStringParam(String paramName) {
            return this.req.getParameter(paramName);
        }

        @Override
        public HttpServletResponse getHttpServletResponse() {
            return this.resp;
        }
    }

    private static final class MapParamContainer
    extends ParamContainer {
        private final Map<String, String> map;
        private final EnumComponent component;

        public MapParamContainer(Map<String, String> map, EnumComponent component) {
            this.map = map;
            this.component = component;
        }

        @Override
        public Set<String> getParameterNames() {
            return this.map.keySet();
        }

        @Override
        public Date checkDateParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return new Date(Long.parseLong(tmp));
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public int[] checkIntArrayParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            String[] sa = SPLIT.split(tmp, 0);
            int[] intArray = new int[sa.length];
            for (int a = 0; a < sa.length; ++a) {
                try {
                    intArray[a] = Integer.parseInt(sa[a]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
                }
            }
            return intArray;
        }

        @Override
        public int checkIntParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public long checkLongParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            try {
                return Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public String checkStringParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                throw ParamContainerExceptionCode.MISSING_PARAMETER.create(paramName);
            }
            return tmp;
        }

        @Override
        public Date getDateParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                return null;
            }
            try {
                return new Date(Long.parseLong(tmp));
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public String getHeader(String hdrName) {
            return null;
        }

        @Override
        public int[] getIntArrayParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                return null;
            }
            String[] sa = SPLIT.split(tmp, 0);
            int[] intArray = new int[sa.length];
            for (int a = 0; a < sa.length; ++a) {
                try {
                    intArray[a] = Integer.parseInt(sa[a]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
                }
            }
            return intArray;
        }

        @Override
        public int getIntParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                return -9999;
            }
            try {
                return Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public long getLongParam(String paramName) throws OXException {
            String tmp = this.map.get(paramName);
            if (tmp == null) {
                return -9999L;
            }
            try {
                return Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                throw ParamContainerExceptionCode.BAD_PARAM_VALUE.create(tmp, paramName);
            }
        }

        @Override
        public String getStringParam(String paramName) {
            return this.map.get(paramName);
        }

        @Override
        public HttpServletResponse getHttpServletResponse() {
            return null;
        }
    }
}

