/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.request.ResourceRequest;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
extends DataServlet {
    private static final transient Logger LOG = LoggerFactory.getLogger(Resource.class);
    private static final long serialVersionUID = -8381608654367561643L;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Resource.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            String action = Resource.parseMandatoryStringParameter(httpServletRequest, "action");
            JSONObject jsonObj = null;
            try {
                jsonObj = Resource.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse, session);
                return;
            }
            ResourceRequest resourceRequest = new ResourceRequest(session);
            Object responseObj = resourceRequest.action(action, jsonObj);
            response.setTimestamp(resourceRequest.getTimestamp());
            response.setData(responseObj);
        }
        catch (OXException e) {
            LOG.error("doGet", (Throwable)e);
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error("", (Throwable)oje);
            response.setException(oje);
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Response response;
        ServerSession session;
        block10: {
            session = Resource.getSessionObject((ServletRequest)httpServletRequest);
            response = new Response(session);
            try {
                String action = Resource.parseMandatoryStringParameter(httpServletRequest, "action");
                String data = Resource.getBody(httpServletRequest);
                if (data.charAt(0) == '[') {
                    JSONArray jData = null;
                    try {
                        jData = new JSONArray(data);
                    }
                    catch (JSONException e) {
                        OXException exc = OXJSONExceptionCodes.JSON_READ_ERROR.create(e, data);
                        response.setException(exc);
                        this.writeResponse(response, httpServletResponse, session);
                        LOG.error("", (Throwable)exc);
                        return;
                    }
                    JSONObject jsonObj = null;
                    try {
                        jsonObj = Resource.convertParameter2JSONObject(httpServletRequest);
                    }
                    catch (JSONException e) {
                        LOG.error("doPut", (Throwable)e);
                        response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                        this.writeResponse(response, httpServletResponse, session);
                        return;
                    }
                    jsonObj.put("data", (Object)jData);
                    ResourceRequest resourceRequest = new ResourceRequest(session);
                    Object responseObj = resourceRequest.action(action, jsonObj);
                    response.setTimestamp(resourceRequest.getTimestamp());
                    response.setData(responseObj);
                    break block10;
                }
                JSONObject jData = null;
                JSONObject jsonObj = null;
                try {
                    jData = new JSONObject(data);
                    jsonObj = Resource.convertParameter2JSONObject(httpServletRequest);
                }
                catch (JSONException e) {
                    LOG.error("doPut", (Throwable)e);
                    response.setException(OXJSONExceptionCodes.JSON_READ_ERROR.create(e, new Object[0]));
                    this.writeResponse(response, httpServletResponse, session);
                    return;
                }
                jsonObj.put("data", (Object)jData);
                ResourceRequest resourceRequest = new ResourceRequest(session);
                Object responseObj = resourceRequest.action(action, jsonObj);
                response.setTimestamp(resourceRequest.getTimestamp());
                response.setData(responseObj);
            }
            catch (OXException e) {
                LOG.error("doPut", (Throwable)e);
                response.setException(e);
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                LOG.error("", (Throwable)oje);
                response.setException(oje);
            }
        }
        this.writeResponse(response, httpServletResponse, session);
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return true;
    }
}

