/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NonBlockingCallableExecutor<V> {
    private final AtomicInteger writeCounter = new AtomicInteger();
    private final Lock lock = new ReentrantLock();

    public V readCall(Callable<V> task) throws Exception {
        int save = 0;
        V value = null;
        while (true) {
            if (((save = this.writeCounter.get()) & 1) > 0) {
                continue;
            }
            value = task.call();
            if (save == this.writeCounter.get()) break;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V writeCall(Callable<V> task) throws Exception {
        V value;
        this.lock.lock();
        try {
            this.writeCounter.incrementAndGet();
            value = task.call();
        }
        finally {
            this.writeCounter.incrementAndGet();
            this.lock.unlock();
        }
        return value;
    }
}

