/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class InterruptibleInputStream
extends InputStream {
    private volatile IOException interrupted;
    private final InputStream in;

    public InterruptibleInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        IOException interrupted = this.interrupted;
        if (interrupted != null) {
            throw interrupted;
        }
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        IOException interrupted = this.interrupted;
        if (interrupted != null) {
            throw interrupted;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void reset() throws IOException {
        IOException interrupted = this.interrupted;
        if (interrupted != null) {
            throw interrupted;
        }
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        IOException interrupted = this.interrupted;
        if (interrupted != null) {
            throw interrupted;
        }
        return this.in.skip(n);
    }

    @Override
    public int read(byte[] b) throws IOException {
        IOException interrupted = this.interrupted;
        if (interrupted != null) {
            throw interrupted;
        }
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IOException interrupted = this.interrupted;
        if (interrupted != null) {
            throw interrupted;
        }
        return this.in.read(b, off, len);
    }

    public boolean isInterrupted() {
        return this.interrupted != null;
    }

    public void interrupt() {
        this.interrupt(new InterruptedIOException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(IOException exc) {
        IOException interrupted = this.interrupted;
        if (null == interrupted) {
            InterruptibleInputStream interruptibleInputStream = this;
            synchronized (interruptibleInputStream) {
                interrupted = this.interrupted;
                if (interrupted != null) {
                    throw new IllegalStateException("Input stream already interrupted.");
                }
                interrupted = exc;
                Streams.close((Closeable)this.in);
            }
        }
    }
}

