/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.datatypes.genericonf;

import com.openexchange.datatypes.genericonf.DynamicFormIterator;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.datatypes.genericonf.IterationBreak;
import com.openexchange.datatypes.genericonf.WidgetSwitcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicFormDescription
implements Iterable<FormElement> {
    private final List<FormElement> formElements;
    private final Map<String, FormElement> namedElements = new HashMap<String, FormElement>();

    public DynamicFormDescription() {
        this.formElements = new ArrayList<FormElement>();
    }

    @Override
    public Iterator<FormElement> iterator() {
        return this.formElements.iterator();
    }

    public List<FormElement> getFormElements() {
        return Collections.unmodifiableList(this.formElements);
    }

    public void addFormElement(FormElement formElement) {
        this.formElements.add(formElement);
        this.namedElements.put(formElement.getName(), formElement);
    }

    public void removeFormElement(FormElement formElement) {
        this.formElements.remove(formElement);
        this.namedElements.remove(formElement.getName());
    }

    public DynamicFormDescription add(FormElement formElement) {
        this.addFormElement(formElement);
        return this;
    }

    public List<Object> doSwitch(WidgetSwitcher switcher, Object ... args) {
        ArrayList<Object> retvals = new ArrayList<Object>(this.formElements.size());
        for (FormElement element : this.formElements) {
            retvals.add(element.doSwitch(switcher, args));
        }
        return retvals;
    }

    public void iterate(DynamicFormIterator iterator, Map<String, Object> content) {
        for (FormElement element : this.formElements) {
            try {
                String name = element.getName();
                if (!content.containsKey(name)) continue;
                iterator.handle(element, content.get(name));
            }
            catch (IterationBreak e) {
                return;
            }
        }
    }

    public Set<String> getMissingMandatoryFields(Map<String, Object> content) {
        HashSet<String> missing = new HashSet<String>();
        for (FormElement element : this.formElements) {
            if (!element.isMandatory() || content.containsKey(element.getName())) continue;
            missing.add(element.getName());
        }
        return missing;
    }

    public FormElement getField(String col) {
        return this.namedElements.get(col);
    }
}

