/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.osgi;

import com.openexchange.config.Reloadable;
import com.openexchange.config.internal.ConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableServiceTracker
implements ServiceTrackerCustomizer<Reloadable, Reloadable> {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableServiceTracker.class);
    private final ConfigurationImpl configService;
    private final BundleContext context;

    public ReloadableServiceTracker(BundleContext context, ConfigurationImpl configService) {
        this.context = context;
        this.configService = configService;
    }

    public Reloadable addingService(ServiceReference<Reloadable> serviceRef) {
        Reloadable service = (Reloadable)this.context.getService(serviceRef);
        if (this.configService.addReloadable(service)) {
            LOG.debug("Reloadable service added: " + service.getClass().getName());
            return service;
        }
        this.context.ungetService(serviceRef);
        return null;
    }

    public void modifiedService(ServiceReference<Reloadable> serviceRef, Reloadable reloadable) {
    }

    public void removedService(ServiceReference<Reloadable> serviceRef, Reloadable reloadable) {
        this.configService.removeReloadable(reloadable);
        LOG.debug("Reloadable service removed: " + reloadable.getClass().getName());
        this.context.ungetService(serviceRef);
    }
}

