/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.framework;

import com.openexchange.groupware.container.DataObject;
import com.openexchange.webdav.xml.framework.AbstractWebDAVParser;
import com.openexchange.webdav.xml.framework.CommonInsertResponse;
import com.openexchange.webdav.xml.types.Response;
import org.jdom2.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInsertParser<T extends CommonInsertResponse>
extends AbstractWebDAVParser<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInsertParser.class);

    protected AbstractInsertParser() {
    }

    @Override
    protected T createResponse(Document document, Response[] responses) {
        T retval = this.instantiateResponse(document, responses);
        if (responses.length == 1) {
            if (responses[0].hasError()) {
                AbstractInsertParser.fail((String)responses[0].getErrorMessage());
            }
            DataObject object = (DataObject)responses[0].getDataObject();
            ((CommonInsertResponse)retval).setIdentifier(object.getObjectID());
            ((CommonInsertResponse)retval).setTimestamp(object.getLastModified());
        } else {
            LOG.error("Don't know how to handle multi insert responses: " + responses.length);
        }
        return retval;
    }

    protected abstract T instantiateResponse(Document var1, Response[] var2);
}

