/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;

public class AttachmentTest
extends AbstractWebdavXMLTest {
    public static final String ATTACHMENT_URL = "/servlet/webdav.attachments";
    public static final String CONTENT_TYPE = "image/png";
    public static final byte[] data = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 1, 3, 0, 0, 0, 37, -37, 86, -54, 0, 0, 0, 6, 80, 76, 84, 69, -1, -1, -1, -1, -1, -1, 85, 124, -11, 108, 0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102, 0, 0, 0, 1, 98, 75, 71, 68, 0, -120, 5, 29, 72, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 11, 18, 0, 0, 11, 18, 1, -46, -35, 126, -4, 0, 0, 0, 10, 73, 68, 65, 84, 120, -38, 99, 96, 0, 0, 0, 2, 0, 1, -27, 39, -34, -4, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    public AttachmentTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public static int insertAttachment(WebConversation webCon, AttachmentMetadata attachmentObj, InputStream is, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        PutMethodWebRequest webRequest = new PutMethodWebRequest(host + ATTACHMENT_URL, is, attachmentObj.getFileMIMEType());
        webRequest.setHeaderField("Authorization", "Basic " + AttachmentTest.getAuthData(login, password, context));
        webRequest.setHeaderField("filename", attachmentObj.getFilename());
        webRequest.setHeaderField("module", String.valueOf(attachmentObj.getModuleId()));
        webRequest.setHeaderField("target_id", String.valueOf(attachmentObj.getAttachedId()));
        webRequest.setHeaderField("target_folder_id", String.valueOf(attachmentObj.getFolderId()));
        if (attachmentObj.getRtfFlag()) {
            webRequest.setHeaderField("rtf_flag", String.valueOf(attachmentObj.getRtfFlag()));
        }
        WebResponse webResponse = webCon.getResponse((WebRequest)webRequest);
        AttachmentTest.assertEquals((int)207, (int)webResponse.getResponseCode());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(webResponse.getText().getBytes(Charsets.UTF_8));
        Document doc = new SAXBuilder().build((InputStream)byteArrayInputStream);
        return AttachmentTest.parseResponse(doc, false);
    }

    public static InputStream loadAttachment(WebConversation webCon, AttachmentMetadata attachmentObj, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        GetMethodWebRequest webRequest = new GetMethodWebRequest(host + ATTACHMENT_URL);
        webRequest.setHeaderField("Authorization", "Basic " + AttachmentTest.getAuthData(login, password, context));
        webRequest.setHeaderField("module", String.valueOf(attachmentObj.getModuleId()));
        webRequest.setHeaderField("target_id", String.valueOf(attachmentObj.getAttachedId()));
        webRequest.setHeaderField("target_folder_id", String.valueOf(attachmentObj.getFolderId()));
        webRequest.setHeaderField("object_id", String.valueOf(attachmentObj.getId()));
        WebResponse webResponse = webCon.getResponse((WebRequest)webRequest);
        AttachmentTest.assertEquals((int)200, (int)webResponse.getResponseCode());
        return webResponse.getInputStream();
    }

    protected void deleteAttachment(WebConversation webCon, AttachmentMetadata attachmentObj, String host, String login, String password) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(login, password));
        DeleteMethod deleteMethod = new DeleteMethod(host + ATTACHMENT_URL);
        deleteMethod.setDoAuthentication(true);
        deleteMethod.setRequestHeader("module", String.valueOf(attachmentObj.getModuleId()));
        deleteMethod.setRequestHeader("target_id", String.valueOf(attachmentObj.getAttachedId()));
        deleteMethod.setRequestHeader("object_id", String.valueOf(attachmentObj.getId()));
        deleteMethod.setRequestHeader("target_folder_id", String.valueOf(attachmentObj.getFolderId()));
        httpclient.executeMethod((HttpMethod)deleteMethod);
        AttachmentTest.assertEquals((String)deleteMethod.getResponseBodyAsString(), (int)200, (int)deleteMethod.getStatusCode());
    }

    public void compareAttachments(AttachmentMetadata attachmentObj1, AttachmentMetadata attachmentObj2) throws Exception {
        AttachmentTest.assertEquals((String)"filename is not equals", (String)attachmentObj1.getFilename(), (String)attachmentObj2.getFilename());
        AttachmentTest.assertEquals((String)"module is not equals", (int)attachmentObj1.getModuleId(), (int)attachmentObj2.getModuleId());
        AttachmentTest.assertEquals((String)"target id is not equals", (int)attachmentObj1.getAttachedId(), (int)attachmentObj2.getAttachedId());
        AttachmentTest.assertEquals((String)"target folder id is not equals", (int)attachmentObj1.getFolderId(), (int)attachmentObj2.getFolderId());
        AttachmentTest.assertEquals((String)"rtf flag is not equals", (boolean)attachmentObj1.getRtfFlag(), (boolean)attachmentObj2.getRtfFlag());
    }
}

