/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavMkcolAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;

public class MkcolTest
extends ActionTestCase {
    public void testCreateCollection() throws Exception {
        WebdavPath NEW_COLLECTION = this.testCollection.dup().append(new String[]{"newCollection"});
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(NEW_COLLECTION);
        WebdavMkcolAction action = new WebdavMkcolAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        MkcolTest.assertEquals((int)201, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(NEW_COLLECTION);
        MkcolTest.assertTrue((resource.exists() && resource.isCollection() ? 1 : 0) != 0);
    }

    public void testInvalidParent() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(new WebdavPath((CharSequence)"doesntExist/lalala"));
        WebdavMkcolAction action = new WebdavMkcolAction();
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            MkcolTest.fail((String)"Expected 409 CONFLICT or 412 PRECONDITION FAILED");
        }
        catch (WebdavProtocolException e) {
            MkcolTest.assertTrue((String)("" + e.getStatus()), (409 == e.getStatus() || 412 == e.getStatus() ? 1 : 0) != 0);
        }
    }
}

