/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.tx.AbstractActionTest;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.SaveFileAction;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.internal.LocalFileStorageFactory;
import com.openexchange.tx.UndoableAction;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;

public class SaveFileActionTest
extends AbstractActionTest {
    private static final String content = "I am the test content";
    private File tempFile;
    private SaveFileAction saveFile = null;
    private FileStorage storage = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempFile = File.createTempFile("filestorage", ".tmp");
        this.tempFile.delete();
        FileStorage.setFileStorageStarter((FileStorageFactory)new LocalFileStorageFactory());
    }

    protected void tearDown() throws Exception {
        SaveFileActionTest.rmdir(this.tempFile);
        FileStorage.setFileStorageStarter(null);
        super.tearDown();
    }

    private static void rmdir(File tempFile) {
        if (tempFile.isDirectory()) {
            for (File f : tempFile.listFiles()) {
                SaveFileActionTest.rmdir(f);
            }
        }
        tempFile.delete();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        this.storage = FileStorage.getInstance((URI)this.tempFile.toURI());
        this.saveFile = new SaveFileAction(this.storage, (InputStream)new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)), 0L);
        return this.saveFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verifyPerformed() throws Exception {
        SaveFileActionTest.assertTrue((null != this.saveFile.getFileStorageID() ? 1 : 0) != 0);
        BufferedInputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            in = new BufferedInputStream(this.storage.getFile(this.saveFile.getFileStorageID()), 65536);
            int b = 0;
            while ((b = ((InputStream)in).read()) != -1) {
                out.write(b);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close((Closeable[])new Closeable[]{in, out});
            throw throwable;
        }
        Streams.close((Closeable[])new Closeable[]{in, out});
        String got = new String(out.toByteArray(), Charsets.UTF_8);
        SaveFileActionTest.assertEquals((String)content, (String)got);
    }

    @Override
    protected void verifyUndone() throws Exception {
        try {
            this.storage.getFile(this.saveFile.getFileStorageID());
            SaveFileActionTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            SaveFileActionTest.assertTrue((boolean)true);
        }
    }
}

