/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.resourcecache;

import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.exception.OXException;
import com.openexchange.test.resourcecache.actions.AbstractResourceCacheRequest;
import com.openexchange.test.resourcecache.actions.ConfigurationRequest;
import com.openexchange.test.resourcecache.actions.ConfigurationResponse;
import com.openexchange.test.resourcecache.actions.DeleteRequest;
import com.openexchange.test.resourcecache.actions.DownloadRequest;
import com.openexchange.test.resourcecache.actions.DownloadResponse;
import com.openexchange.test.resourcecache.actions.UploadRequest;
import com.openexchange.test.resourcecache.actions.UploadResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceCacheTest
extends AbstractAJAXSession {
    private static final String FS = "FS";
    private static final String DB = "DB";
    private String current = "FS";

    public ResourceCacheTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearCache();
        super.tearDown();
    }

    private void clearCache() throws OXException, IOException, JSONException {
        DeleteRequest deleteRequest = new DeleteRequest();
        this.executeTyped(deleteRequest, this.current);
    }

    public void testLifecycleFS() throws Exception {
        this.current = FS;
        this.lifecycle();
    }

    public void testLifecycleDB() throws Exception {
        this.current = DB;
        this.lifecycle();
    }

    private void lifecycle() throws Exception {
        byte[] file = this.prepareFile(1024);
        UploadRequest uploadRequest = new UploadRequest();
        uploadRequest.addFile("someimage.jpg", "image/jpeg", new ByteArrayInputStream(file));
        UploadResponse uploadResponse = this.executeTyped(uploadRequest, this.current);
        List<String> ids = uploadResponse.getIds();
        ResourceCacheTest.assertEquals((String)"wrong number of ids", (int)1, (int)ids.size());
        DownloadRequest downloadRequest = new DownloadRequest(ids.get(0));
        DownloadResponse downloadResponse = this.executeTyped(downloadRequest, this.current);
        byte[] reloaded = downloadResponse.getBytes();
        ResourceCacheTest.assertTrue((String)"download was not equals upload", (boolean)Arrays.equals(file, reloaded));
        DeleteRequest deleteRequest = new DeleteRequest(ids.get(0));
        this.executeTyped(deleteRequest, this.current);
        downloadResponse = this.executeTyped(downloadRequest, this.current);
        ResourceCacheTest.assertNull((String)"resource was not deleted", (Object)downloadResponse.getBytes());
    }

    public void testQuotaAndInvalidationFS() throws Exception {
        this.current = FS;
        this.quotaAndInvalidation();
    }

    public void testQuotaAndInvalidationDB() throws Exception {
        this.current = DB;
        this.quotaAndInvalidation();
    }

    private void quotaAndInvalidation() throws Exception {
        int[] qts = this.loadQuotas();
        int quota = qts[0];
        int perDocument = qts[1];
        if (this.current.equals(DB)) {
            perDocument = Math.min(perDocument, (int)Math.pow(2.0, 16.0) - 2);
        }
        int n = quota / perDocument;
        if (quota <= 0 || perDocument <= 0 || n < 1) {
            ResourceCacheTest.fail((String)"test system is misconfigured. Set correct quotas in preview.properties!");
        }
        byte[] file = this.prepareFile(perDocument);
        UploadRequest uploadRequest = new UploadRequest();
        for (int i = 0; i < n; ++i) {
            uploadRequest.addFile("someimage_" + i + ".jpg", "image/jpeg", new ByteArrayInputStream(file));
        }
        UploadResponse uploadResponse = this.executeTyped(uploadRequest, this.current);
        List<String> ids = uploadResponse.getIds();
        ResourceCacheTest.assertEquals((String)"wrong number of ids", (int)n, (int)ids.size());
        for (String id : ids) {
            DownloadRequest downloadRequest = new DownloadRequest(id);
            DownloadResponse downloadResponse = this.executeTyped(downloadRequest, this.current);
            byte[] reloaded = downloadResponse.getBytes();
            ResourceCacheTest.assertNotNull((String)"resource not found", (Object)reloaded);
            ResourceCacheTest.assertTrue((String)"download was not equals upload", (boolean)Arrays.equals(file, reloaded));
        }
        uploadRequest = new UploadRequest();
        uploadRequest.addFile("someimage_" + n + ".jpg", "image/jpeg", new ByteArrayInputStream(file));
        uploadResponse = this.executeTyped(uploadRequest, this.current);
        ResourceCacheTest.assertEquals((String)"newest resource was not added", (int)1, (int)uploadResponse.getIds().size());
        DownloadRequest downloadRequest = new DownloadRequest(uploadResponse.getIds().get(0));
        DownloadResponse downloadResponse = this.executeTyped(downloadRequest, this.current);
        byte[] reloaded = downloadResponse.getBytes();
        ResourceCacheTest.assertNotNull((String)"resource not found", (Object)reloaded);
        ResourceCacheTest.assertTrue((String)"download was not equals upload", (boolean)Arrays.equals(file, reloaded));
        int missing = 0;
        for (String id : ids) {
            downloadRequest = new DownloadRequest(id);
            downloadResponse = this.executeTyped(downloadRequest, this.current);
            reloaded = downloadResponse.getBytes();
            if (reloaded != null) continue;
            ++missing;
        }
        ResourceCacheTest.assertEquals((String)"Exactly one old resource should have been deleted", (int)1, (int)missing);
    }

    public void testResourceExceedsQuota() throws Exception {
        this.current = FS;
        this.resourceExceedsQuota();
    }

    private void resourceExceedsQuota() throws Exception {
        int[] qts = this.loadQuotas();
        int perDocument = qts[1];
        byte[] file = this.prepareFile(perDocument + 1);
        UploadRequest uploadRequest = new UploadRequest();
        uploadRequest.addFile("someimage.jpg", "image/jpeg", new ByteArrayInputStream(file));
        UploadResponse uploadResponse = this.executeTyped(uploadRequest, this.current);
        ResourceCacheTest.assertEquals((String)"resource should not have been cached", (int)0, (int)uploadResponse.getIds().size());
    }

    private int[] loadQuotas() throws Exception {
        ConfigurationRequest configurationRequest = new ConfigurationRequest();
        ConfigurationResponse configurationResponse = this.executeTyped(configurationRequest, this.current);
        JSONObject config = configurationResponse.getConfigObject();
        int quota = config.getInt("com.openexchange.preview.cache.quota");
        int perDocument = config.getInt("com.openexchange.preview.cache.quotaPerDocument");
        return new int[]{quota, perDocument};
    }

    private <T extends AbstractAJAXResponse> T executeTyped(AbstractResourceCacheRequest<T> request, String cacheType) throws OXException, IOException, JSONException {
        request.setCacheType(cacheType);
        return this.client.execute(request);
    }

    private byte[] prepareFile(int length) {
        Random r = new Random();
        byte[] file = new byte[length];
        r.nextBytes(file);
        return file;
    }
}

