/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.subscribe.Subscription;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionFixtureFactory
implements FixtureFactory<Subscription> {
    private final FixtureLoader fixtureLoader;

    public SubscriptionFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<Subscription> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new SubscriptionFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class SubscriptionFixtures
    extends DefaultFixtures<Subscription>
    implements Fixtures<Subscription> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Subscription>> subscriptions;

        public SubscriptionFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader) {
            super(Subscription.class, entries, fixtureLoader);
            this.subscriptions = new HashMap<String, Fixture<Subscription>>();
            this.entries = entries;
        }

        @Override
        public Fixture<Subscription> getEntry(String entryName) throws OXException {
            if (this.subscriptions.containsKey(entryName)) {
                return this.subscriptions.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            this.defaults(values);
            Subscription subscription = new Subscription();
            HashMap<String, String> config = new HashMap<String, String>();
            if (values.containsKey("source")) {
                config.put("source", values.get("source"));
                values.remove("source");
            }
            if (values.containsKey("url")) {
                config.put("url", values.get("url"));
                values.remove("url");
            }
            if (values.containsKey("login")) {
                config.put("login", values.get("login"));
                values.remove("login");
            }
            if (values.containsKey("password")) {
                config.put("password", values.get("password"));
                values.remove("password");
            }
            subscription.setConfiguration(config);
            this.apply(subscription, values);
            Fixture<Subscription> fixture = new Fixture<Subscription>(subscription, values.keySet().toArray(new String[values.size()]), values);
            this.subscriptions.put(entryName, fixture);
            return fixture;
        }

        private void defaults(Map<String, String> values) {
            if (!values.containsKey("displayName")) {
                values.put("displayName", values.get("login"));
            }
            if (!values.containsKey("secret")) {
                values.put("secret", values.get("false"));
            }
        }
    }
}

