/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.ajax.task.actions.TaskUpdatesResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.ajax.task.actions.UpdatesRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TestTask;
import com.openexchange.test.TestManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.Assert;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class TaskTestManager
implements TestManager {
    protected List<Task> createdEntities;
    private AJAXClient client;
    protected TimeZone timezone;
    protected int taskFolderId;
    private boolean failOnError;
    private AbstractAJAXResponse lastResponse;
    private Throwable lastException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskTestManager(AJAXClient client) {
        this.setFailOnError(true);
        this.setClient(client);
        this.createdEntities = new LinkedList<Task>();
        try {
            this.taskFolderId = client.getValues().getPrivateTaskFolder();
        }
        catch (Exception e) {
            this.doHandleExeption(e, "getting private task folder from user values");
        }
        try {
            this.timezone = client.getValues().getTimeZone();
        }
        catch (OXException e) {
        }
        catch (IOException e) {
        }
        catch (JSONException jSONException) {
        }
        finally {
            if (this.timezone == null) {
                this.timezone = TimeZone.getDefault();
            }
        }
    }

    public Task insertTaskOnServer(Task taskToCreate) {
        this.createdEntities.add(taskToCreate);
        InsertRequest request = new InsertRequest(taskToCreate, this.timezone);
        InsertResponse response = null;
        try {
            response = this.getClient().execute(request);
            this.setLastResponse(response);
            response.fillTask(taskToCreate);
        }
        catch (Exception e) {
            this.doHandleExeption(e, "NewRequest on folder " + taskToCreate.getParentFolderID());
        }
        return taskToCreate;
    }

    public Task updateTaskOnServer(Task taskToUpdate) {
        UpdateRequest request = new UpdateRequest(taskToUpdate, this.timezone);
        UpdateResponse response = null;
        try {
            response = this.getClient().execute(request);
            this.setLastResponse(response);
        }
        catch (Exception e) {
            this.doHandleExeption(e, "UpdateRequest for task ID " + taskToUpdate.getObjectID());
        }
        taskToUpdate.setLastModified(response.getTimestamp());
        for (Task co : this.createdEntities) {
            if (taskToUpdate.getObjectID() != co.getObjectID()) continue;
            co.setLastModified(response.getTimestamp());
        }
        return taskToUpdate;
    }

    public Task moveTaskOnServer(Task taskToMove, int sourceFolder) {
        UpdateRequest request = new UpdateRequest(sourceFolder, taskToMove, this.timezone);
        UpdateResponse response = null;
        try {
            response = this.getClient().execute(request);
            this.setLastResponse(response);
            taskToMove.setLastModified(response.getTimestamp());
        }
        catch (Exception e) {
            this.doHandleExeption(e, "MoveRequest");
        }
        return taskToMove;
    }

    public void deleteTaskOnServer(Task taskToDelete) {
        this.deleteTaskOnServer(taskToDelete, true);
    }

    public void deleteTaskOnServer(Task taskToDelete, boolean failOnErrorOverride) {
        DeleteRequest request = new DeleteRequest(taskToDelete, failOnErrorOverride);
        try {
            this.setLastResponse(this.getClient().execute(request));
        }
        catch (Exception e) {
            this.doHandleExeption(e, "DeleteRequest for " + taskToDelete.getObjectID());
        }
        this.createdEntities.remove(taskToDelete);
    }

    public Task getTaskFromServer(int folder, int objectId) {
        GetRequest request = new GetRequest(folder, objectId, this.getFailOnError());
        GetResponse response = null;
        try {
            response = this.getClient().execute(request);
            this.setLastResponse(response);
            return response.getTask(this.timezone);
        }
        catch (Exception e) {
            this.doHandleExeption(e, "TaskRequest for task id " + objectId);
            return null;
        }
    }

    public Task getTaskFromServer(Task task) {
        return this.getTaskFromServer(task.getParentFolderID(), task.getObjectID());
    }

    public Task[] getUpdatedTasksOnServer(int folder, int[] columns, Date lastModified) {
        UpdatesRequest req = new UpdatesRequest(folder, columns, -1, null, lastModified);
        TaskUpdatesResponse resp = null;
        try {
            resp = this.getClient().execute(req);
            this.setLastResponse(resp);
        }
        catch (Exception e) {
            this.doHandleExeption(e, "UpdatesRequest");
            return null;
        }
        return resp.getTasks().toArray(new Task[0]);
    }

    public Task[] getAllTasksOnServer(int folderID, int[] columns) {
        AllRequest allTasksRequest = new AllRequest(folderID, columns, 1, Order.ASCENDING);
        try {
            CommonAllResponse allTasksResponse = this.getClient().execute(allTasksRequest);
            this.setLastResponse(allTasksResponse);
            JSONArray jsonTasks = (JSONArray)allTasksResponse.getData();
            LinkedList<Task> tasks = new LinkedList<Task>();
            for (int j = 0; j < jsonTasks.length(); ++j) {
                JSONArray taskAsArray = (JSONArray)jsonTasks.get(j);
                Task task = TaskTestManager.transformArrayToTask(taskAsArray, allTasksResponse.getColumns());
                tasks.add(task);
            }
            return tasks.toArray(new Task[tasks.size()]);
        }
        catch (Exception e) {
            this.doHandleExeption(e, "AllRequest for folder " + folderID);
            return null;
        }
    }

    public Task[] getAllTasksOnServer(int folderID) {
        return this.getAllTasksOnServer(folderID, Task.ALL_COLUMNS);
    }

    public Task[] listContactsOnServer(int[][] folderAndTaskIds, int[] columns) {
        ListRequest req = new ListRequest(folderAndTaskIds, columns);
        CommonListResponse resp = null;
        List<Task> tasks = null;
        try {
            resp = this.getClient().execute(req);
            this.setLastResponse(resp);
            tasks = this.transformArrayToTasks((JSONArray)resp.getData(), resp.getColumns());
        }
        catch (Exception e) {
            this.doHandleExeption(e, "ListRequest");
        }
        return tasks == null ? null : tasks.toArray(new Task[0]);
    }

    public Task searchForTasksOnServer() {
        return null;
    }

    protected static Object transformColumn(int column, Object value) {
        Object retval;
        switch (column) {
            case 4: 
            case 5: 
            case 201: 
            case 202: 
            case 208: 
            case 216: 
            case 315: {
                retval = new Date((Long)value);
                break;
            }
            case 303: 
            case 308: {
                retval = Long.valueOf((String)value);
                break;
            }
            case 302: 
            case 307: {
                retval = new BigDecimal(value.toString());
                break;
            }
            case 305: {
                retval = value;
                break;
            }
            default: {
                retval = value;
            }
        }
        return retval;
    }

    protected List<Task> transformArrayToTasks(JSONArray tasks, int[] columns) throws JSONException {
        LinkedList<Task> results = new LinkedList<Task>();
        int length = tasks.length();
        for (int i = 0; i < length; ++i) {
            results.add(TaskTestManager.transformArrayToTask(tasks.getJSONArray(i), columns));
        }
        return results;
    }

    protected static Task transformArrayToTask(JSONArray taskAsArray, int[] columns) throws JSONException {
        Task resultingTask = new Task();
        for (int i = 0; i < columns.length; ++i) {
            int column = columns[i];
            Mapper attributeMapping = Mapping.getMapping((int)column);
            if (taskAsArray.isNull(i) || attributeMapping == null || taskAsArray.get(i) == null) continue;
            Object newValue = TaskTestManager.transformColumn(column, taskAsArray.get(i));
            attributeMapping.set(resultingTask, newValue);
        }
        return resultingTask;
    }

    @Override
    public void cleanUp() {
        for (Task task : new LinkedList<Task>(this.createdEntities)) {
            this.deleteTaskOnServer(task);
        }
    }

    public Task findTaskByID(int id, List<Task> tasks) {
        for (Task task : tasks) {
            if (id != task.getObjectID()) continue;
            return task;
        }
        Assert.fail((String)("Task with id=" + id + " not found"));
        return null;
    }

    public Task findTaskByID(int id, Task[] tasks) {
        return this.findTaskByID(id, Arrays.asList(tasks));
    }

    public TestTask newTask(String title) throws OXException, IOException, SAXException, JSONException {
        TestTask task = new TestTask();
        task.setTitle(title);
        UserValues values = this.getClient().getValues();
        task.setTimezone(values.getTimeZone());
        task.setParentFolderID(values.getPrivateTaskFolder());
        task.setCreatedBy(values.getUserId());
        task.setModifiedBy(values.getUserId());
        return task;
    }

    private void doHandleExeption(Exception exc, String action) {
        block10: {
            try {
                this.lastException = exc;
                throw exc;
            }
            catch (OXException e) {
                if (this.getFailOnError()) {
                    Assert.fail((String)("AJAXException during " + action + ": " + e.getMessage()));
                }
            }
            catch (IOException e) {
                if (this.getFailOnError()) {
                    Assert.fail((String)("IOException during " + action + ": " + e.getMessage()));
                }
            }
            catch (SAXException e) {
                if (this.getFailOnError()) {
                    Assert.fail((String)("SAXException during " + action + ": " + e.getMessage()));
                }
            }
            catch (JSONException e) {
                if (this.getFailOnError()) {
                    Assert.fail((String)("JSONException during " + action + ": " + e.getMessage()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.getFailOnError()) break block10;
                Assert.fail((String)("Unexpected exception during " + action + ": " + e.getMessage()));
            }
        }
    }

    public void setLastResponse(AbstractAJAXResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    @Override
    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    @Override
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Override
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Override
    public boolean doesFailOnError() {
        return this.getFailOnError();
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public boolean hasLastException() {
        return this.lastException != null;
    }
}

