/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.vcard;

import com.openexchange.groupware.vcard.AbstractVCardUnitTest;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.converter.ConverterException;
import java.io.IOException;

public class VCardMimeTypeTest
extends AbstractVCardUnitTest {
    public final String vcard1 = "BEGIN:VCARD\nVERSION:3.0\nPRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nNICKNAME:Tierlieb\nBDAY:19810501\nADR;TYPE=work:;;;Somewhere;NRW;58641;DE\nTEL;TYPE=home,voice:+49 2538 7921\nEMAIL:tobias.prinz@open-xchange.com\nORG:- deactivated -\nREV:20061204T160750.018Z\nURL:www.tobias-prinz.de\nUID:80@ox6.netline.de\nEND:VCARD\n";
    public final String vcard2 = "BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD";

    public void test6962variant1() throws IOException, ConverterException {
        this.performTest("vCard 1 as text/x-vcard", "BEGIN:VCARD\nVERSION:3.0\nPRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nNICKNAME:Tierlieb\nBDAY:19810501\nADR;TYPE=work:;;;Somewhere;NRW;58641;DE\nTEL;TYPE=home,voice:+49 2538 7921\nEMAIL:tobias.prinz@open-xchange.com\nORG:- deactivated -\nREV:20061204T160750.018Z\nURL:www.tobias-prinz.de\nUID:80@ox6.netline.de\nEND:VCARD\n", "text/x-vcard");
    }

    public void test6962variant2() throws IOException, ConverterException {
        try {
            this.performTest("vCard 2 as text/x-vcard", "BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD", "text/x-vcard");
            VCardMimeTypeTest.fail((String)"Should not be able to parse this as VCard 2.1");
        }
        catch (VersitException e) {
            VCardMimeTypeTest.assertTrue((boolean)true);
        }
    }

    public void test6962variant3() throws IOException, ConverterException {
        this.performTest("vCard 1 as text/vcard", "BEGIN:VCARD\nVERSION:3.0\nPRODID:OPEN-XCHANGE\nFN:Prinz\\, Tobias\nN:Prinz;Tobias;;;\nNICKNAME:Tierlieb\nBDAY:19810501\nADR;TYPE=work:;;;Somewhere;NRW;58641;DE\nTEL;TYPE=home,voice:+49 2538 7921\nEMAIL:tobias.prinz@open-xchange.com\nORG:- deactivated -\nREV:20061204T160750.018Z\nURL:www.tobias-prinz.de\nUID:80@ox6.netline.de\nEND:VCARD\n", "text/vcard");
    }

    public void test6962variant4() throws IOException, ConverterException {
        this.performTest("vCard 2 as text/vcard", "BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD", "text/vcard");
    }
}

