/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.calendar.RecurringResults;
import com.openexchange.calendar.recurrence.RecurringCalculation;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public class RecurringCalculationTest
extends TestCase {
    public void testShouldCalculateInTimeZone() throws OXException {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        TimeZone ny = TimeZone.getTimeZone("America/New York");
        RecurringCalculation calc = new RecurringCalculation(4, 1, 0);
        Date start = CommonAppointments.recalculate(CommonAppointments.D("07/02/1981 19:00"), utc, ny);
        Date end = CommonAppointments.recalculate(CommonAppointments.D("09/02/1981 23:00"), utc, ny);
        calc.setStartAndEndTime(start.getTime(), end.getTime());
        calc.setOccurrence(3);
        calc.setMonth(1);
        calc.setDayInMonth(5);
        RecurringResultInterface recurringResult = calc.calculateRecurrence().getRecurringResult(2);
        Date startExpected = CommonAppointments.recalculate(CommonAppointments.D("05/02/1983 19:00"), utc, ny);
        Date endExpected = CommonAppointments.recalculate(CommonAppointments.D("05/02/1983 23:00"), utc, ny);
        RecurringCalculationTest.assertEquals((String)CommonAppointments.dateString(recurringResult.getStart(), ny), (long)startExpected.getTime(), (long)recurringResult.getStart());
        RecurringCalculationTest.assertEquals((String)CommonAppointments.dateString(recurringResult.getEnd(), ny), (long)endExpected.getTime(), (long)recurringResult.getEnd());
    }

    public void testWorkweekRelativeRecurrence() throws OXException {
        Date start = CommonAppointments.D("05/12/2007 10:00");
        Date end = CommonAppointments.D("05/12/2007 12:00");
        RecurringCalculation calc = new RecurringCalculation(3, 1, 0);
        calc.setStartAndEndTime(start.getTime(), end.getTime());
        calc.setDays(62);
        calc.setDayInMonth(3);
        calc.setOccurrence(5);
        RecurringResults results = calc.calculateRecurrence();
        Date[] days = new Date[]{CommonAppointments.D("05/12/2007 10:00"), CommonAppointments.D("03/01/2008 10:00"), CommonAppointments.D("05/02/2008 10:00"), CommonAppointments.D("05/03/2008 10:00"), CommonAppointments.D("03/04/2008 10:00")};
        for (int i = 0; i < 5; ++i) {
            long expected = days[i].getTime();
            long actual = results.getRecurringResult(i).getStart();
            RecurringCalculationTest.assertEquals((String)(new Date(expected) + " expected. Was: " + new Date(actual)), (long)expected, (long)actual);
        }
    }

    public void testWeekendRelativeRecurrence() throws OXException {
        Date start = CommonAppointments.D("02/12/2007 10:00");
        Date end = CommonAppointments.D("02/12/2007 12:00");
        RecurringCalculation calc = new RecurringCalculation(3, 1, 0);
        calc.setStartAndEndTime(start.getTime(), end.getTime());
        calc.setDays(65);
        calc.setDayInMonth(2);
        calc.setOccurrence(5);
        RecurringResults results = calc.calculateRecurrence();
        Date[] days = new Date[]{CommonAppointments.D("02/12/2007 10:00"), CommonAppointments.D("06/01/2008 10:00"), CommonAppointments.D("03/02/2008 10:00"), CommonAppointments.D("02/03/2008 10:00"), CommonAppointments.D("06/04/2008 10:00")};
        for (int i = 0; i < 5; ++i) {
            long expected = days[i].getTime();
            long actual = results.getRecurringResult(i).getStart();
            RecurringCalculationTest.assertEquals((String)(new Date(expected) + " expected. Was: " + new Date(actual)), (long)expected, (long)actual);
        }
    }

    public void testRecurrencesGoOnUntil99YearsInTheFuture() throws OXException {
        RecurringCalculation calc = new RecurringCalculation(4, 1, 0);
        Date start = CommonAppointments.D("05/11/1900 10:00");
        calc.setStartAndEndTime(start.getTime(), CommonAppointments.D("05/11/1900 12:00").getTime());
        calc.setDayInMonth(11);
        calc.setMonth(4);
        RecurringResults results = calc.calculateRecurrence();
        long threshold = start.getTime() + 3456000000L;
        int size = results.size();
        for (int i = 0; i < size; ++i) {
            if (threshold >= results.getRecurringResult(i).getStart()) continue;
            return;
        }
        RecurringCalculationTest.fail((String)"Couldn't find future recurrence for unlimited series");
    }
}

