/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class MutableUserConfigurationStorage
extends UserConfigurationStorage {
    private UserConfigurationStorage delegate;
    private ConcurrentHashMap<Integer, UserConfiguration> overrides = new ConcurrentHashMap();

    public MutableUserConfigurationStorage(UserConfigurationStorage delegate) {
        this.delegate = delegate;
    }

    protected void startInternal() throws OXException {
    }

    protected void stopInternal() throws OXException {
    }

    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        UserConfiguration userConfiguration = this.overrides.get(userId);
        if (userConfiguration != null) {
            return userConfiguration;
        }
        return this.delegate.getUserConfiguration(userId, groups, ctx);
    }

    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        HashMap<Integer, UserConfiguration> ucs = new HashMap<Integer, UserConfiguration>();
        ArrayList<User> toLoad = new ArrayList<User>(users.length);
        for (User user : users) {
            UserConfiguration configuration = this.overrides.get(user.getId());
            if (configuration == null) {
                toLoad.add(user);
                continue;
            }
            ucs.put(user.getId(), configuration);
        }
        if (!toLoad.isEmpty()) {
            UserConfiguration[] userConfigurations;
            for (UserConfiguration userConfiguration : userConfigurations = this.delegate.getUserConfiguration(ctx, toLoad.toArray(new User[toLoad.size()]))) {
                ucs.put(userConfiguration.getUserId(), userConfiguration);
            }
        }
        UserConfiguration[] retval = new UserConfiguration[users.length];
        int i = 0;
        for (User user : users) {
            retval[i++] = (UserConfiguration)ucs.get(user.getId());
        }
        return retval;
    }

    public UserConfiguration[] getUserConfigurations(Context ctx, int[] userIds, int[][] groups) throws OXException {
        HashMap<Integer, UserConfiguration> ucs = new HashMap<Integer, UserConfiguration>();
        ArrayList<Integer> toLoad = new ArrayList<Integer>(userIds.length);
        ArrayList<int[]> groupArr = new ArrayList<int[]>(userIds.length);
        for (int i = 0; i < userIds.length; ++i) {
            int userId = userIds[i];
            UserConfiguration configuration = this.overrides.get(userId);
            if (configuration == null) {
                toLoad.add(userId);
                groupArr.add(groups[i]);
                continue;
            }
            ucs.put(userId, configuration);
        }
        if (!toLoad.isEmpty()) {
            UserConfiguration[] userConfigurations;
            int[] ids = new int[toLoad.size()];
            int[][] groups2 = new int[toLoad.size()][];
            for (int i = 0; i < toLoad.size(); ++i) {
                ids[i] = (Integer)toLoad.get(i);
                groups2[i] = (int[])groupArr.get(i);
            }
            for (UserConfiguration userConfiguration : userConfigurations = this.delegate.getUserConfigurations(ctx, ids, (int[][])groups2)) {
                ucs.put(userConfiguration.getUserId(), userConfiguration);
            }
        }
        UserConfiguration[] retval = new UserConfiguration[userIds.length];
        int i = 0;
        for (int userId : userIds) {
            retval[i++] = (UserConfiguration)ucs.get(userId);
        }
        return retval;
    }

    public void saveUserConfiguration(UserConfiguration configuration) {
        this.overrides.put(configuration.getUserId(), configuration);
    }

    public void clearStorage() throws OXException {
        this.overrides.clear();
    }

    public void invalidateCache(int userId, Context ctx) throws OXException {
        this.overrides.remove(userId);
    }
}

