/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.WebDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.carddav.reports.AddressbookMultiGetReportInfo;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.ContactTestManager;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.cardme.engine.VCardEngine;
import net.sourceforge.cardme.io.CompatibilityMode;
import net.sourceforge.cardme.vcard.exceptions.VCardParseException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CardDAVTest
extends WebDAVTest {
    protected static final int TIMEOUT = 10000;
    private ContactTestManager testManager = null;
    private int folderId;
    private VCardEngine vCardEngine;

    public CardDAVTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testManager = new ContactTestManager(this.getAJAXClient());
        this.getManager().setFailOnError(true);
        this.folderId = this.getAJAXClient().getValues().getPrivateContactFolder();
        this.vCardEngine = new VCardEngine(CompatibilityMode.MAC_ADDRESS_BOOK);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.getManager()) {
            this.getManager().cleanUp();
        }
        super.tearDown();
    }

    @Override
    protected String getDefaultUserAgent() {
        return "AddressBook/6.1 (1083) CardDAVPlugin/200 CFNetwork/520.3.2 Mac_OS_X/10.7.3 (11D50d)";
    }

    protected void rememberForCleanUp(Contact contact) {
        this.getManager().getCreatedEntities().add(contact);
    }

    protected int getDefaultFolderID() {
        return this.folderId;
    }

    protected int getGABFolderID() {
        return 6;
    }

    protected ContactTestManager getManager() {
        return this.testManager;
    }

    protected VCardEngine getVCardEngine() {
        return this.vCardEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int delete(String uid) throws OXException, HttpException, IOException {
        int n;
        DeleteMethod delete = null;
        try {
            String href = "/carddav/Contacts/" + uid + ".vcf";
            delete = new DeleteMethod(CardDAVTest.getBaseUri() + href);
            n = this.getWebDAVClient().executeMethod((HttpMethod)delete);
        }
        catch (Throwable throwable) {
            CardDAVTest.release(delete);
            throw throwable;
        }
        CardDAVTest.release((HttpMethodBase)delete);
        return n;
    }

    protected void delete(Contact contact) {
        this.getManager().deleteAction(contact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCTag() throws OXException, IOException, DavException {
        String string;
        PropFindMethod propFind = null;
        try {
            DavPropertyNameSet props = new DavPropertyNameSet();
            props.add(PropertyNames.GETCTAG);
            propFind = new PropFindMethod(CardDAVTest.getBaseUri() + "/carddav/Contacts/", 0, props, 0);
            MultiStatusResponse response = CardDAVTest.assertSingleResponse(this.getWebDAVClient().doPropFind(propFind, 207));
            string = this.extractTextContent(PropertyNames.GETCTAG, response);
        }
        catch (Throwable throwable) {
            CardDAVTest.release(propFind);
            throw throwable;
        }
        CardDAVTest.release((HttpMethodBase)propFind);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putVCard(String uid, String vCard) throws HttpException, IOException, OXException {
        int n;
        PutMethod put = null;
        try {
            String href = "/carddav/Contacts/" + uid + ".vcf";
            put = new PutMethod(CardDAVTest.getBaseUri() + href);
            put.addRequestHeader("If-None-Match", "*");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(vCard, "text/vcard", "UTF-8"));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CardDAVTest.release(put);
            throw throwable;
        }
        CardDAVTest.release((HttpMethodBase)put);
        return n;
    }

    protected int putVCardUpdate(String uid, String vCard) throws HttpException, IOException, OXException {
        return this.putVCardUpdate(uid, vCard, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int putVCardUpdate(String uid, String vCard, String ifMatchEtag) throws HttpException, IOException, OXException {
        int n;
        PutMethod put = null;
        try {
            String href = "/carddav/Contacts/" + uid + ".vcf";
            put = new PutMethod(CardDAVTest.getBaseUri() + href);
            if (null != ifMatchEtag) {
                put.addRequestHeader("If-Match", ifMatchEtag);
            }
            put.setRequestEntity((RequestEntity)new StringRequestEntity(vCard, "text/vcard", "UTF-8"));
            n = this.getWebDAVClient().executeMethod((HttpMethod)put);
        }
        catch (Throwable throwable) {
            CardDAVTest.release(put);
            throw throwable;
        }
        CardDAVTest.release((HttpMethodBase)put);
        return n;
    }

    protected String fetchSyncToken() throws OXException, IOException, DavException {
        return super.fetchSyncToken("/carddav/Contacts");
    }

    protected Map<String, String> syncCollection(String syncToken) throws OXException, IOException, DavException {
        return super.syncCollection(syncToken, "/carddav/Contacts");
    }

    protected SyncCollectionResponse syncCollection(SyncToken syncToken) throws OXException, IOException, DavException {
        return super.syncCollection(syncToken, "/carddav/Contacts");
    }

    protected List<VCardResource> getVCardsSince(String syncToken) throws Exception {
        Map<String, String> eTags = this.syncCollection(syncToken);
        return this.addressbookMultiget(eTags.keySet());
    }

    protected List<VCardResource> getAllVCards() throws Exception {
        Map<String, String> eTags = this.getAllETags();
        return this.addressbookMultiget(eTags.keySet());
    }

    protected VCardResource getGlobalAddressbookVCard() throws Exception {
        GetResponse response = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, this.getGABFolderID()));
        String gabFolderName = response.getFolder().getFolderName();
        return this.getGroupVCard(gabFolderName);
    }

    protected VCardResource getGroupVCard(String folderName) throws Exception {
        List<VCardResource> groupVCards = this.getAllGroupVCards();
        for (VCardResource resource : groupVCards) {
            if (!folderName.equals(resource.getVCard().getFN().getFormattedName())) continue;
            return resource;
        }
        CardDAVTest.fail((String)("no vCard representing the folder '" + folderName + "' found"));
        return null;
    }

    protected List<VCardResource> getAllGroupVCards() throws Exception {
        Map<String, String> eTags = this.getAllETags();
        List<VCardResource> vCards = this.addressbookMultiget(eTags.keySet());
        ArrayList<VCardResource> groupVCards = new ArrayList<VCardResource>();
        for (VCardResource resource : vCards) {
            if (!resource.isGroup()) continue;
            groupVCards.add(resource);
        }
        return groupVCards;
    }

    protected Map<String, String> getAllETags() throws OXException, IOException, DavException {
        MultiStatusResponse[] responses;
        HashMap<String, String> eTags = new HashMap<String, String>();
        DavPropertyNameSet propertyNames = new DavPropertyNameSet();
        propertyNames.add(PropertyNames.GETETAG);
        PropFindMethod propFind = new PropFindMethod(CardDAVTest.getBaseUri() + "/carddav/Contacts", propertyNames, 1);
        for (MultiStatusResponse response : responses = this.getWebDAVClient().doPropFind(propFind, 207)) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            CardDAVTest.assertNotNull((String)"got no href from response", (Object)href);
            String eTag = this.extractTextContent(PropertyNames.GETETAG, response);
            CardDAVTest.assertNotNull((String)"got no ETag from response", (Object)eTag);
            eTags.put(href, eTag);
        }
        return eTags;
    }

    protected List<VCardResource> addressbookMultiget(Collection<String> hrefs) throws OXException, IOException, DavException, VCardParseException {
        MultiStatusResponse[] responses;
        ArrayList<VCardResource> addressData = new ArrayList<VCardResource>();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.GETETAG);
        props.add(PropertyNames.ADDRESS_DATA);
        AddressbookMultiGetReportInfo reportInfo = new AddressbookMultiGetReportInfo(hrefs.toArray(new String[hrefs.size()]), props);
        for (MultiStatusResponse response : responses = this.getWebDAVClient().doReport(reportInfo, CardDAVTest.getBaseUri() + "/carddav/Contacts/")) {
            if (!response.getProperties(200).contains(PropertyNames.GETETAG)) continue;
            String href = response.getHref();
            CardDAVTest.assertNotNull((String)"got no href from response", (Object)href);
            String data = this.extractTextContent(PropertyNames.ADDRESS_DATA, response);
            CardDAVTest.assertNotNull((String)"got no address data from response", (Object)data);
            String eTag = this.extractTextContent(PropertyNames.GETETAG, response);
            CardDAVTest.assertNotNull((String)"got no etag data from response", (Object)eTag);
            addressData.add(new VCardResource(data, href, eTag));
        }
        return addressData;
    }

    protected VCardResource getVCard(String uid) throws Exception {
        String href = "/carddav/Contacts/" + uid + ".vcf";
        List<VCardResource> vCards = this.addressbookMultiget(Arrays.asList(href));
        CardDAVTest.assertNotNull((String)"no vCards found", vCards);
        CardDAVTest.assertEquals((String)"zero or more than one vCards found", (int)1, (int)vCards.size());
        VCardResource vCard = vCards.get(0);
        CardDAVTest.assertNotNull((String)"no vCard data found", (Object)vCard);
        return vCard;
    }

    private static JSONObject getSearchFilter(String uid, int[] folderIDs) throws JSONException {
        String filter = null;
        if (null == folderIDs || 0 == folderIDs.length) {
            filter = "{'filter' : [ '=' , {'field' : 'uid'} , '" + uid + "']}";
        } else if (1 == folderIDs.length) {
            filter = "{'filter' : [ 'and', ['=' , {'field' : 'uid'} , '" + uid + "'], " + "['=' , {'field' : 'fid'}, '" + folderIDs[0] + "']" + "]})";
        } else {
            filter = "{'filter' : [ 'and', ['=' , {'field' : 'uid'} , '" + uid + "'], " + "[ 'or', " + "['=' , {'field' : 'fid'}, '" + folderIDs[0] + "'] ";
            for (int i = 1; i < folderIDs.length; ++i) {
                filter = filter + ", " + "['=' , {'field' : 'fid'}, '" + folderIDs[i] + "'] ";
            }
            filter = filter + "]" + "]})";
        }
        return new JSONObject(filter);
    }

    protected Contact searchContact(String uid, int[] folderIDs, int[] columnIDs) throws JSONException {
        Contact[] contacts = this.getManager().searchAction(CardDAVTest.getSearchFilter(uid, folderIDs), null == columnIDs ? Contact.ALL_COLUMNS : columnIDs, -1, null);
        return null != contacts && 0 < contacts.length ? contacts[0] : null;
    }

    protected Contact getContact(String uid) throws InterruptedException, JSONException {
        return this.getContact(uid, null);
    }

    protected List<Contact> getContacts(int folderID) throws InterruptedException, JSONException {
        Contact[] contacts = this.getManager().allAction(folderID);
        return Arrays.asList(contacts);
    }

    protected Contact getContact(String uid, int folderID) throws InterruptedException, JSONException {
        return this.getContact(uid, new int[]{folderID});
    }

    protected Contact getContact(String uid, int[] folderIDs) throws InterruptedException, JSONException {
        return this.searchContact(uid, folderIDs, null);
    }

    protected Contact waitForContact(String uid) throws InterruptedException, JSONException {
        return this.waitForContact(uid, null);
    }

    protected Contact waitForContact(String uid, int folderID) throws InterruptedException, JSONException {
        return this.waitForContact(uid, new int[]{folderID});
    }

    protected Contact waitForContact(String uid, int[] folderIDs) throws InterruptedException, JSONException {
        long timeoutTime = new Date().getTime() + 10000L;
        do {
            Contact contact;
            if (null != (contact = this.getContact(uid, folderIDs))) {
                return contact;
            }
            Thread.sleep(500L);
        } while (new Date().getTime() < timeoutTime);
        return null;
    }

    protected Contact[] findContacts(String pattern) {
        return this.getManager().searchAction(pattern, this.getDefaultFolderID());
    }

    protected Contact findContact(String pattern) {
        Contact[] contacts = this.findContacts(pattern);
        CardDAVTest.assertNotNull((String)"no contacts found", (Object)contacts);
        CardDAVTest.assertEquals((String)"zero or more than one contact found", (int)1, (int)contacts.length);
        return contacts[0];
    }

    protected Contact create(Contact contact) {
        return this.create(contact, this.getDefaultFolderID());
    }

    protected Contact update(int originalFolderID, Contact contact) {
        return this.getManager().updateAction(originalFolderID, contact);
    }

    protected Contact update(Contact contact) {
        return this.getManager().updateAction(contact);
    }

    protected Contact create(Contact contact, int folderID) {
        contact.setParentFolderID(folderID);
        return this.getManager().newAction(contact);
    }

    @Override
    protected FolderObject createFolder(FolderObject folder) throws OXException, IOException, JSONException {
        InsertResponse response = this.getClient().execute(new InsertRequest(EnumAPI.OX_NEW, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        return folder;
    }

    @Override
    protected FolderObject updateFolder(FolderObject folder) throws OXException, IOException, JSONException {
        InsertResponse response = this.getClient().execute(new UpdateRequest(EnumAPI.OX_NEW, folder));
        folder.setLastModified(response.getTimestamp());
        return folder;
    }

    protected FolderObject getDefaultFolder() throws OXException, IOException, JSONException {
        return this.getFolder(this.getDefaultFolderID());
    }

    protected FolderObject getGABFolder() throws OXException, IOException, JSONException {
        return this.getFolder(this.getGABFolderID());
    }

    protected FolderObject createFolder(String folderName) throws OXException, IOException, JSONException {
        return super.createFolder(this.getDefaultFolder(), folderName);
    }

    protected static String formatAsUTC(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmm'00Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    protected static DistributionListEntryObject asDistListMember(Contact contact) throws OXException {
        DistributionListEntryObject member = new DistributionListEntryObject();
        member.setFolderID(contact.getParentFolderID());
        member.setEntryID(contact.getObjectID());
        member.setDisplayname(contact.getDisplayName());
        member.setFirstname(contact.getGivenName());
        member.setLastname(contact.getSurName());
        member.setEmailfield(1);
        if (contact.containsEmail1()) {
            member.setEmailaddress(contact.getEmail1());
        } else if (contact.containsEmail2()) {
            member.setEmailaddress(contact.getEmail2());
            member.setEmailfield(2);
        } else if (contact.containsEmail3()) {
            member.setEmailaddress(contact.getEmail3());
            member.setEmailfield(3);
        }
        return member;
    }

    public static VCardResource assertContains(String uid, Collection<VCardResource> vCards) {
        VCardResource match = null;
        for (VCardResource vCard : vCards) {
            if (!uid.equals(vCard.getUID())) continue;
            CardDAVTest.assertNull((String)("duplicate match for UID '" + uid + "'"), match);
            match = vCard;
        }
        CardDAVTest.assertNotNull((String)("no vCard with UID '" + uid + "' found"), match);
        return match;
    }

    public static VCardResource assertContainsFN(String formattedName, Collection<VCardResource> vCards) {
        VCardResource match = null;
        for (VCardResource vCard : vCards) {
            if (!formattedName.equals(vCard.getFN())) continue;
            match = vCard;
            break;
        }
        CardDAVTest.assertNotNull((String)("no vCard with FN '" + formattedName + "' found"), (Object)match);
        return match;
    }

    public static String assertContainsMemberUID(String uid, VCardResource groupVCard) {
        List<String> members = groupVCard.getMemberUIDs();
        CardDAVTest.assertNotNull((String)"no members found in group vcard", members);
        String match = null;
        for (String memberUid : members) {
            if (!uid.equals(memberUid)) continue;
            match = memberUid;
            break;
        }
        CardDAVTest.assertNotNull((String)("no group member with UID '" + uid + "' found"), (Object)match);
        return match;
    }

    public static void assertNotContainsMemberUID(String uid, VCardResource groupVCard) {
        List<String> members = groupVCard.getMemberUIDs();
        String match = null;
        for (String memberUid : members) {
            if (!uid.equals(memberUid)) continue;
            match = memberUid;
            break;
        }
        CardDAVTest.assertNull((String)("group member with UID '" + uid + "' found"), (Object)match);
    }

    public static void assertNotContainsFN(String formattedName, Collection<VCardResource> vCards) {
        if (null != vCards && 0 < vCards.size()) {
            for (VCardResource vCard : vCards) {
                CardDAVTest.assertFalse((String)("vCard with FN '" + formattedName + "' found"), (boolean)formattedName.equals(vCard.getFN()));
            }
        }
    }

    public static void assertNotContains(String uid, Collection<VCardResource> vCards) {
        if (null != vCards && 0 < vCards.size()) {
            for (VCardResource vCard : vCards) {
                CardDAVTest.assertFalse((String)("vCard with UID '" + uid + "' found"), (boolean)uid.equals(vCard.getUID()));
            }
        }
    }
}

