/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;

public class Bug28490Test
extends CalDAVTest {
    public Bug28490Test(String name) {
        super(name);
    }

    public void testTimeZoneCET() throws Exception {
        String uid = Bug28490Test.randomUID();
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle(((Object)((Object)this)).getClass().getCanonicalName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(TimeTools.D("last january on friday at 16:00", TimeZone.getTimeZone("CET")));
        appointment.setEndDate(TimeTools.D("last january on friday at 16:30", TimeZone.getTimeZone("CET")));
        appointment.setRecurrenceType(2);
        appointment.setDays(32);
        appointment.setInterval(1);
        appointment.setTimezone("CET");
        super.create(appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = super.get(uid, null);
        Bug28490Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug28490Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug28490Test.assertNotNull((String)"No TZID attribute found in DTSTART property", (Object)iCalResource.getVEvent().getProperty("DTSTART").getAttribute("TZID"));
        Bug28490Test.assertNotNull((String)"No TZID attribute found in DTEND property", (Object)iCalResource.getVEvent().getProperty("DTEND").getAttribute("TZID"));
    }
}

