/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.user.actions.AbstractUserRequest;
import com.openexchange.ajax.user.actions.ListParser;
import com.openexchange.ajax.user.actions.ListResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class ListRequest
extends AbstractUserRequest<ListResponse> {
    private final int[] userIds;
    private final int[] columns;
    private final Map<String, Set<String>> attributeParameters;

    public ListRequest(int[] userIds, int[] columns) {
        this.userIds = userIds;
        this.columns = columns;
        this.attributeParameters = new HashMap<String, Set<String>>(4);
    }

    public void putAttributeParameter(String prefix, String name) {
        Set<String> set = this.attributeParameters.get(prefix);
        if (null == set) {
            set = new HashSet<String>(4);
            this.attributeParameters.put(prefix, set);
        }
        set.add(name);
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray json = new JSONArray();
        for (int userId : this.userIds) {
            json.put(userId);
        }
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> l = new ArrayList<AJAXRequest.Parameter>(6);
        l.add(new AJAXRequest.Parameter("action", "list"));
        l.add(new AJAXRequest.Parameter("columns", this.columns));
        if (!this.attributeParameters.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : this.attributeParameters.entrySet()) {
                l.add(new AJAXRequest.Parameter(entry.getKey(), ListRequest.toCSV((Collection<String>)entry.getValue())));
            }
        }
        return l.toArray(new AJAXRequest.Parameter[l.size()]);
    }

    private static String toCSV(Collection<String> c) {
        Iterator<String> iterator = c.iterator();
        if (iterator.hasNext()) {
            StringBuilder sb = new StringBuilder(32);
            sb.append(iterator.next());
            while (iterator.hasNext()) {
                sb.append(',').append(iterator.next());
            }
            return sb.toString();
        }
        return "";
    }

    public ListParser getParser() {
        return new ListParser(true, this.columns);
    }
}

