/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;

public class TaskDurationAndCostsTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task task;
    private TimeZone tz;

    public TaskDurationAndCostsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.task.setTitle("Set task duration and costs test");
        this.task.setActualDuration(Autoboxing.L((long)2L));
        this.task.setActualCosts(new BigDecimal("2.0"));
        this.task.setTargetDuration(Autoboxing.L((long)10L));
        this.task.setTargetCosts(new BigDecimal("10.0"));
        InsertRequest request = new InsertRequest(this.task, this.tz);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    public void tearDown() throws Exception {
        DeleteRequest req = new DeleteRequest(this.task);
        this.client.execute(req);
    }

    public void testDurationAndCosts() throws Exception {
        this.task.setTargetCosts(new BigDecimal("11.5"));
        this.task.setActualCosts(new BigDecimal("4.728"));
        this.task.setActualDuration(Autoboxing.L((long)7L));
        this.task.setTargetDuration(Autoboxing.L((long)15L));
        UpdateRequest req = new UpdateRequest(this.task, this.tz, false);
        try {
            UpdateResponse response = this.client.execute(req);
            this.task.setLastModified(response.getTimestamp());
        }
        catch (AssertionFailedError e) {
            TaskDurationAndCostsTest.fail((String)"Setting costs and duration failed!");
        }
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        this.task.setLastModified(response.getTimestamp());
        Task test = response.getTask(this.tz);
        TaskDurationAndCostsTest.assertEquals((String)"Actual costs not equal", (Object)this.task.getActualCosts().round(new MathContext(3)), (Object)test.getActualCosts().round(new MathContext(3)));
        TaskDurationAndCostsTest.assertEquals((String)"Target costs not equal", (Object)this.task.getTargetCosts(), (Object)test.getTargetCosts());
        TaskDurationAndCostsTest.assertEquals((String)"Actual duration not equal", (Object)this.task.getActualDuration(), (Object)test.getActualDuration());
        TaskDurationAndCostsTest.assertEquals((String)"Target duration not equal", (Object)this.task.getTargetDuration(), (Object)test.getTargetDuration());
    }
}

