/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import org.json.JSONArray;

public class ListAliasTest
extends AbstractTaskTest {
    private AJAXClient client;
    private Task task;

    public ListAliasTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest delete = new DeleteRequest(this.task);
        this.client.execute(delete);
        super.tearDown();
    }

    public void testAll() throws Throwable {
        this.task = new Task();
        this.task.setTitle("Task TestListAlias");
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertRequest insertRequest = new InsertRequest(this.task, this.getTimeZone());
        InsertResponse insertResponse = this.client.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.task);
        AllRequest allRequest = new AllRequest(this.client.getValues().getPrivateTaskFolder(), new int[]{20, 1}, 0, Order.NO_ORDER);
        CommonAllResponse allResponse = this.client.execute(allRequest);
        ListIDs ids = allResponse.getListIDs();
        ListRequest aliasRequest = new ListRequest(ids, "list");
        CommonListResponse aliasResponse = this.client.execute(aliasRequest);
        Object[][] tasksAlias = aliasResponse.getArray();
        ListRequest request = new ListRequest(ids, new int[]{20, 1, 5, 2, 4, 209, 301, 101, 200, 309, 201, 202, 102});
        CommonListResponse response = this.client.execute(request);
        Object[][] tasks = response.getArray();
        ListAliasTest.assertEquals((String)"Arrays' sizes are not equal.", (int)tasksAlias.length, (int)tasks.length);
        for (int i = 0; i < tasksAlias.length; ++i) {
            Object[] o1 = tasksAlias[i];
            Object[] o2 = tasks[i];
            ListAliasTest.assertEquals((String)"Objects' sizes are not equal.", (int)o1.length, (int)o2.length);
            for (int j = 0; j < o1.length; ++j) {
                if (o1[j] == null && o2[j] == null) continue;
                if (!(o1[j] instanceof JSONArray) && !(o2[j] instanceof JSONArray)) {
                    ListAliasTest.assertEquals((String)("Array[" + i + "][" + j + "] not equal."), (Object)o1[j], (Object)o2[j]);
                    continue;
                }
                this.compareArrays((JSONArray)o1[j], (JSONArray)o2[j]);
            }
        }
    }

    private void compareArrays(JSONArray o1, JSONArray o2) throws Exception {
        if (o1.length() != o2.length()) {
            ListAliasTest.fail((String)"Arrays' sizes are not equal.");
        }
        for (int i = 0; i < o1.length(); ++i) {
            if (o1.get(i) == null && o2.get(i) == null) continue;
            if (!(o1.get(i) instanceof JSONArray) && !(o2.get(i) instanceof JSONArray)) {
                ListAliasTest.assertEquals((String)("Array[" + i + "] not equal."), (String)o1.get(i).toString(), (String)o2.get(i).toString());
                continue;
            }
            this.compareArrays((JSONArray)o1.get(i), (JSONArray)o2.get(i));
        }
    }
}

