/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.task.ManagedTaskTest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import junit.framework.AssertionFailedError;

public class BasicManagedTaskTests
extends ManagedTaskTest {
    public BasicManagedTaskTests(String name) {
        super(name);
    }

    public void testCreateAndGet() {
        Task expected = this.generateTask("Create test");
        this.manager.insertTaskOnServer(expected);
        this.actual = this.manager.getTaskFromServer(expected);
        BasicManagedTaskTests.assertEquals((String)"Should have the same title", (String)expected.getTitle(), (String)this.actual.getTitle());
        BasicManagedTaskTests.assertEquals((String)"Should have the same folder", (int)expected.getParentFolderID(), (int)this.actual.getParentFolderID());
        BasicManagedTaskTests.assertEquals((String)"Should have the same start date", (Object)TimeTools.removeMilliseconds(expected.getStartDate()), (Object)this.actual.getStartDate());
        BasicManagedTaskTests.assertEquals((String)"Should have the same end date", (Object)TimeTools.removeMilliseconds(expected.getEndDate()), (Object)this.actual.getEndDate());
        BasicManagedTaskTests.assertEquals((String)"Should have the same last modified", (Object)expected.getLastModified(), (Object)this.actual.getLastModified());
    }

    public void testAll() {
        int numberBefore = this.manager.getAllTasksOnServer(this.folderID, new int[]{1, 4, 5, 20, 209}).length;
        Task expected = this.generateTask("Create test");
        this.manager.insertTaskOnServer(expected);
        Task[] allTasksOnServer = this.manager.getAllTasksOnServer(this.folderID, new int[]{1, 4, 5, 20, 209});
        this.actual = null;
        for (Task temp : allTasksOnServer) {
            if (expected.getObjectID() != temp.getObjectID()) continue;
            this.actual = temp;
        }
        BasicManagedTaskTests.assertEquals((String)"Should find one more element than before", (int)(numberBefore + 1), (int)allTasksOnServer.length);
        BasicManagedTaskTests.assertNotNull((String)"Should find the newly created element", (Object)this.actual);
        BasicManagedTaskTests.assertEquals((String)"Should have the same field #1 (id)", (Object)expected.get(1), (Object)this.actual.get(1));
        BasicManagedTaskTests.assertEquals((String)"Should have the same field #209", (Object)expected.get(209), (Object)this.actual.get(209));
    }

    public void testUpdateAndReceiveUpdates() {
        Task expected = this.generateTask("Create test");
        this.manager.insertTaskOnServer(expected);
        Task updated = this.generateTask("Updates Test");
        updated.setParentFolderID(expected.getParentFolderID());
        updated.setObjectID(expected.getObjectID());
        updated.setLastModified(expected.getLastModified());
        this.manager.updateTaskOnServer(updated);
        Date aMillisecondEarlier = new Date(expected.getLastModified().getTime() - 1L);
        Task[] updates = this.manager.getUpdatedTasksOnServer(this.folderID, new int[]{1, 4, 5, 209}, aMillisecondEarlier);
        BasicManagedTaskTests.assertEquals((String)"Should find one update only", (int)1, (int)updates.length);
        this.actual = updates[0];
        BasicManagedTaskTests.assertEquals((String)"Should have the same field #1", (Object)expected.get(1), (Object)this.actual.get(1));
        BasicManagedTaskTests.assertEquals((String)"Should have the same field #209", (Object)expected.get(209), (Object)this.actual.get(209));
    }

    public void testCreateAndDelete() {
        Task task = this.generateTask("Create test");
        this.manager.insertTaskOnServer(task);
        this.manager.deleteTaskOnServer(task);
        try {
            this.manager.getTaskFromServer(task);
            BasicManagedTaskTests.fail((String)"Should fail by not finding task");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }
}

