/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.publish.Publication;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublishFolderIconTest
extends AbstractPublicationTest {
    private static final int FLAG_PUBLISHED = 3010;
    private FolderObject folder;

    public PublishFolderIconTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folder = this.fMgr.generatePublicFolder("publishedContacts_" + new Date().getTime(), 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.fMgr.insertFolderOnServer(this.folder);
        Contact contact = this.generateContact("Herbert", "Meier");
        contact.setParentFolderID(this.folder.getObjectID());
        this.cMgr.newAction(contact);
    }

    protected void publish() throws Exception {
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Publication expected = this.generatePublication("contacts", String.valueOf(this.folder.getObjectID()), discovery);
        NewPublicationRequest newReq = new NewPublicationRequest(expected);
        AJAXClient myClient = this.getClient();
        NewPublicationResponse newResp = myClient.execute(newReq);
        expected.setId(newResp.getId());
    }

    public void testShouldSetTheIconViaGet() throws Exception {
        this.fMgr.getFolderFromServer(this.folder.getObjectID(), false, new int[]{3010});
        GetResponse response = (GetResponse)this.fMgr.getLastResponse();
        JSONObject data = (JSONObject)response.getData();
        PublishFolderIconTest.assertTrue((String)"Should contain the key 'com.openexchange.publish.publicationFlag' even before publication", (boolean)data.has("com.openexchange.publish.publicationFlag"));
        PublishFolderIconTest.assertFalse((String)"Key 'com.openexchange.publish.publicationFlag' should have 'false' value before publication", (boolean)data.getBoolean("com.openexchange.publish.publicationFlag"));
        this.publish();
        this.fMgr.getFolderFromServer(this.folder.getObjectID(), false, new int[]{3010});
        response = (GetResponse)this.fMgr.getLastResponse();
        data = (JSONObject)response.getData();
        PublishFolderIconTest.assertTrue((String)"Should contain the key 'com.openexchange.publish.publicationFlag'", (boolean)data.has("com.openexchange.publish.publicationFlag"));
        PublishFolderIconTest.assertTrue((String)"Key 'com.openexchange.publish.publicationFlag' should have 'true' value after publication", (boolean)data.getBoolean("com.openexchange.publish.publicationFlag"));
    }

    public void testShouldSetTheIconViaList() throws Exception {
        boolean published;
        int id;
        JSONArray subfolder;
        int i;
        this.fMgr.listFoldersOnServer(this.folder.getParentFolderID(), new int[]{3010});
        AbstractColumnsResponse response = (AbstractColumnsResponse)this.fMgr.getLastResponse();
        JSONArray folders = (JSONArray)response.getData();
        PublishFolderIconTest.assertTrue((String)"Should return at least one folder", (folders.length() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (i = 0; i < folders.length(); ++i) {
            subfolder = folders.getJSONArray(i);
            id = subfolder.getInt(response.getColumnPos(1));
            published = subfolder.getBoolean(response.getColumnPos(3010));
            if (id != this.folder.getObjectID()) continue;
            found = true;
            PublishFolderIconTest.assertFalse((String)("Folder " + id + " should not be published already"), (boolean)published);
        }
        PublishFolderIconTest.assertTrue((String)("Should find folder " + this.folder.getObjectID() + " as a subfolder of " + this.folder.getParentFolderID() + "."), (boolean)found);
        this.publish();
        this.fMgr.listFoldersOnServer(this.folder.getParentFolderID(), new int[]{3010});
        response = (AbstractColumnsResponse)this.fMgr.getLastResponse();
        folders = (JSONArray)response.getData();
        PublishFolderIconTest.assertTrue((String)"Should return at least one folder", (folders.length() > 0 ? 1 : 0) != 0);
        found = false;
        for (i = 0; i < folders.length(); ++i) {
            subfolder = folders.getJSONArray(i);
            id = subfolder.getInt(response.getColumnPos(1));
            published = subfolder.getBoolean(response.getColumnPos(3010));
            if (id != this.folder.getObjectID()) continue;
            found = true;
            PublishFolderIconTest.assertTrue((String)("Folder " + id + " should not published"), (boolean)published);
        }
        PublishFolderIconTest.assertTrue((String)("Should find folder " + this.folder.getObjectID() + " as a subfolder of " + this.folder.getParentFolderID() + "."), (boolean)found);
    }

    public void testShouldSetTheIconViaUpdates() throws Exception {
        this.fMgr.getFolderFromServer(this.folder);
        Date lastModified = new Date(this.fMgr.getLastResponse().getTimestamp().getTime() - 1L);
        this.fMgr.getUpdatedFoldersOnServer(this.folder.getParentFolderID(), lastModified, new int[]{3010});
        FolderUpdatesResponse response = (FolderUpdatesResponse)this.fMgr.getLastResponse();
        int idPos = this.findPositionOfColumn(response.getColumns(), 1);
        int flagPos = this.findPositionOfColumn(response.getColumns(), 3010);
        JSONArray arr = (JSONArray)response.getData();
        PublishFolderIconTest.assertTrue((String)"Should return at least one update", (arr.length() > 0 ? 1 : 0) != 0);
        int folderPos = this.findPosition(arr, this.folder.getObjectID(), idPos);
        JSONArray data = arr.getJSONArray(folderPos);
        PublishFolderIconTest.assertFalse((String)"Should be false if not published", (boolean)data.getBoolean(flagPos));
        this.publish();
        this.fMgr.getUpdatedFoldersOnServer(this.folder.getParentFolderID(), lastModified, new int[]{3010});
        response = (FolderUpdatesResponse)this.fMgr.getLastResponse();
        arr = (JSONArray)response.getData();
        PublishFolderIconTest.assertTrue((String)"Should return at least one update", (arr.length() > 0 ? 1 : 0) != 0);
        folderPos = this.findPosition(arr, this.folder.getObjectID(), idPos);
        data = arr.getJSONArray(folderPos);
        PublishFolderIconTest.assertTrue((String)"Should be true if published", (boolean)data.getBoolean(flagPos));
    }

    private int findPositionOfColumn(int[] haystack, int needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    private int findPosition(JSONArray arr, int objectID, int idPos) throws JSONException {
        for (int i = 0; i < arr.length(); ++i) {
            if (arr.getJSONArray(i).getInt(idPos) != objectID) continue;
            return i;
        }
        return -1;
    }
}

