/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.publish.actions.AbstractPublicationResponse;
import com.openexchange.ajax.publish.actions.AllPublicationsRequest;
import com.openexchange.ajax.publish.actions.AllPublicationsResponse;
import com.openexchange.ajax.publish.actions.DeletePublicationRequest;
import com.openexchange.ajax.publish.actions.DeletePublicationResponse;
import com.openexchange.ajax.publish.actions.GetPublicationRequest;
import com.openexchange.ajax.publish.actions.GetPublicationResponse;
import com.openexchange.ajax.publish.actions.ListPublicationsRequest;
import com.openexchange.ajax.publish.actions.ListPublicationsResponse;
import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.actions.UpdatePublicationRequest;
import com.openexchange.ajax.publish.actions.UpdatePublicationResponse;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class PublicationTestManager {
    private AbstractPublicationResponse lastResponse;
    private final Set<Integer> createdItems = new HashSet<Integer>();
    private boolean failOnError = true;
    private AJAXClient client;
    private DynamicFormDescription formDescription;
    private PublicationTargetDiscoveryService publicationTargetDiscoveryService;

    public AbstractPublicationResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    public void setFormDescription(DynamicFormDescription formDescription) {
        this.formDescription = formDescription;
    }

    public DynamicFormDescription getFormDescription() {
        return this.formDescription;
    }

    public void setPublicationTargetDiscoveryService(PublicationTargetDiscoveryService service) {
        this.publicationTargetDiscoveryService = service;
    }

    public PublicationTargetDiscoveryService getPublicationTargetDiscoveryService() {
        return this.publicationTargetDiscoveryService;
    }

    public PublicationTestManager() {
    }

    public PublicationTestManager(AJAXClient client) {
        this();
        this.setClient(client);
    }

    public Publication newAction(Publication publication) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        NewPublicationRequest newReq = new NewPublicationRequest(publication);
        newReq.setFailOnError(this.getFailOnError());
        NewPublicationResponse newResp = this.getClient().execute(newReq);
        this.createdItems.add(Autoboxing.I((int)newResp.getId()));
        Publication updatedPublication = this.getAction(newResp.getId());
        publication.setConfiguration(updatedPublication.getConfiguration());
        publication.setId(updatedPublication.getId());
        this.lastResponse = newResp;
        return publication;
    }

    public Publication getAction(int id) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        GetPublicationRequest getReq = new GetPublicationRequest(id);
        getReq.setFailOnError(this.getFailOnError());
        GetPublicationResponse getResp = this.getClient().execute(getReq);
        this.lastResponse = getResp;
        return getResp.getPublication(this.getPublicationTargetDiscoveryService());
    }

    public void deleteAction(Publication publication) throws OXException, IOException, SAXException, JSONException {
        int id = publication.getId();
        DeletePublicationRequest delReq = new DeletePublicationRequest(id);
        delReq.setFailOnError(this.getFailOnError());
        DeletePublicationResponse delResp = this.getClient().execute(delReq);
        this.createdItems.remove(Autoboxing.I((int)id));
        this.lastResponse = delResp;
    }

    public void deleteAction(Collection<Integer> ids) throws OXException, IOException, SAXException, JSONException {
        DeletePublicationRequest delReq = new DeletePublicationRequest(ids);
        delReq.setFailOnError(this.getFailOnError());
        DeletePublicationResponse delResp = this.getClient().execute(delReq);
        this.createdItems.removeAll(ids);
        this.lastResponse = delResp;
    }

    public List<JSONArray> listAction(List<Integer> ids, List<String> columns) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        ListPublicationsRequest listReq = new ListPublicationsRequest(ids, columns);
        listReq.setFailOnError(this.getFailOnError());
        ListPublicationsResponse listResp = this.getClient().execute(listReq);
        this.lastResponse = listResp;
        return listResp.getList();
    }

    public List<JSONArray> listAction(List<Integer> ids, List<String> columns, Map<String, List<String>> dynamicColumns) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        ListPublicationsRequest listReq = new ListPublicationsRequest(ids, columns, dynamicColumns);
        listReq.setFailOnError(this.getFailOnError());
        ListPublicationsResponse listResp = this.getClient().execute(listReq);
        this.lastResponse = listResp;
        return listResp.getList();
    }

    public List<JSONArray> allAction(String folder, int id, String entityModule, List<String> columns) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        AllPublicationsRequest allReq = new AllPublicationsRequest(folder, id, entityModule, columns);
        allReq.setFailOnError(this.getFailOnError());
        AllPublicationsResponse allResp = this.getClient().execute(allReq);
        this.lastResponse = allResp;
        return allResp.getAll();
    }

    public List<JSONArray> allAction(String entityModule, int id, List<String> columns) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        AllPublicationsRequest allReq = new AllPublicationsRequest(id, entityModule, columns);
        allReq.setFailOnError(this.getFailOnError());
        AllPublicationsResponse allResp = this.getClient().execute(allReq);
        this.lastResponse = allResp;
        return allResp.getAll();
    }

    public List<JSONArray> allAction(List<String> columns) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        AllPublicationsRequest allReq = new AllPublicationsRequest(columns);
        allReq.setFailOnError(this.getFailOnError());
        AllPublicationsResponse allResp = this.getClient().execute(allReq);
        this.lastResponse = allResp;
        return allResp.getAll();
    }

    public List<JSONArray> allAction(String folder, int id, String entityModule, List<String> columns, Map<String, List<String>> dynamicColumns) throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        AllPublicationsRequest allReq = new AllPublicationsRequest(folder, id, entityModule, columns, dynamicColumns);
        allReq.setFailOnError(this.getFailOnError());
        AllPublicationsResponse allResp = this.getClient().execute(allReq);
        this.lastResponse = allResp;
        return allResp.getAll();
    }

    public void updateAction(Publication publication) throws OXException, IOException, SAXException, JSONException {
        UpdatePublicationRequest updReq = new UpdatePublicationRequest(publication);
        updReq.setFailOnError(this.getFailOnError());
        UpdatePublicationResponse updResp = this.getClient().execute(updReq);
        this.lastResponse = updResp;
    }

    public void cleanUp() throws OXException, IOException, SAXException, JSONException {
        boolean failOnError2 = this.getFailOnError();
        this.setFailOnError(false);
        if (this.createdItems.size() > 0) {
            this.deleteAction(this.createdItems);
        }
        this.setFailOnError(failOnError2);
    }
}

