/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.participant;

import com.meterware.httpunit.WebConversation;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.user.UserImpl4Test;
import com.openexchange.ajax.user.actions.SearchRequest;
import com.openexchange.ajax.user.actions.SearchResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.search.ContactSearchObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.json.JSONException;
import org.junit.Assert;
import org.xml.sax.SAXException;

public final class ParticipantTools {
    private static final int[] COLUMNS = new int[]{524};
    private static final Random rand = new Random(System.currentTimeMillis());

    private ParticipantTools() {
    }

    public static List<Participant> getParticipants(WebConversation conversation, String hostName, String sessionId) throws Exception {
        Contact[] userContacts = ContactTest.searchContact(conversation, "*", 6, COLUMNS, "http://" + hostName, sessionId);
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (Contact userContact : userContacts) {
            UserParticipant user = new UserParticipant(userContact.getInternalUserId());
            participants.add((Participant)user);
        }
        return participants;
    }

    public static List<Participant> getParticipants(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        ContactSearchObject search = new ContactSearchObject();
        search.setPattern("*");
        search.setFolder(6);
        SearchRequest request = new SearchRequest(search, SearchRequest.DEFAULT_COLUMNS);
        SearchResponse response = client.execute(request);
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (UserImpl4Test user : response.getUser()) {
            participants.add((Participant)new UserParticipant(user.getId()));
        }
        return participants;
    }

    public static List<Participant> createParticipants(int ... userIds) {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (int userId : userIds) {
            participants.add((Participant)new UserParticipant(userId));
        }
        return participants;
    }

    public static List<Participant> getParticipants(WebConversation conversation, String hostName, String sessionId, int count, boolean noCreator, int creatorId) throws Exception {
        List<Participant> participants = ParticipantTools.getParticipants(conversation, hostName, sessionId);
        if (noCreator) {
            ParticipantTools.removeParticipant(participants, creatorId);
        }
        participants = ParticipantTools.extractByRandom(participants, count);
        return participants;
    }

    public static List<Participant> getParticipants(AJAXClient client, int count, int creatorId) throws OXException, IOException, SAXException, JSONException {
        List<Participant> participants = ParticipantTools.getParticipants(client);
        if (-1 != creatorId) {
            ParticipantTools.removeParticipant(participants, creatorId);
        }
        participants = ParticipantTools.extractByRandom(participants, count);
        return participants;
    }

    public static void removeParticipant(List<Participant> participants, int creatorId) {
        Iterator<Participant> iter = participants.iterator();
        while (iter.hasNext()) {
            if (iter.next().getIdentifier() != creatorId) continue;
            iter.remove();
        }
    }

    public static void assertParticipants(Participant[] participants, int ... userIds) {
        for (int userId : userIds) {
            boolean contained = false;
            for (Participant participant : participants) {
                if (1 != participant.getType() || participant.getIdentifier() != userId) continue;
                contained = true;
                break;
            }
            Assert.assertTrue((String)("Participant with identifier " + userId + " is missing."), (boolean)contained);
        }
    }

    public static List<Participant> extractByRandom(List<Participant> participants, int count) {
        ArrayList<Participant> retval = new ArrayList<Participant>();
        do {
            Participant participant;
            if (retval.contains(participant = participants.get(rand.nextInt(participants.size())))) continue;
            retval.add(participant);
        } while (retval.size() < count && retval.size() < participants.size());
        return retval;
    }
}

