/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.oauth.actions.OAuthServicesResponse;
import com.openexchange.ajax.oauth.types.OAuthService;
import com.openexchange.ajax.writer.ResponseWriter;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class OAuthServicesParser
extends AbstractAJAXParser<OAuthServicesResponse> {
    protected OAuthServicesParser(boolean failOnError) {
        super(failOnError);
    }

    @Override
    protected OAuthServicesResponse createResponse(Response response) throws JSONException {
        ArrayList<OAuthService> services = new ArrayList<OAuthService>();
        JSONObject json = ResponseWriter.getJSON((Response)response);
        if (json.has("data")) {
            JSONValue data = (JSONValue)json.get("data");
            if (data.isArray()) {
                JSONArray arr = data.toArray();
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    services.add(this.parseService(obj));
                }
            } else {
                services.add(this.parseService(data.toObject()));
            }
        }
        return new OAuthServicesResponse(response, services);
    }

    protected OAuthService parseService(JSONObject obj) throws JSONException {
        OAuthService service = new OAuthService(obj.getString("id"), obj.getString("displayName"));
        return service;
    }
}

