/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter.writer;

import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.test.AbstractTest;
import com.openexchange.ajax.mail.filter.writer.action.ActionWriter;
import com.openexchange.ajax.mail.filter.writer.action.ActionWriterFactory;
import com.openexchange.ajax.mail.filter.writer.test.TestWriter;
import com.openexchange.ajax.mail.filter.writer.test.TestWriterFactory;
import com.openexchange.ajax.writer.DataWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailFilterWriter
extends DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MailFilterWriter.class);

    public MailFilterWriter() {
        super(null, null);
    }

    public void writeMailFilter(Rule rule, JSONObject jsonObj) throws JSONException {
        JSONObject testObj;
        JSONArray actionCommandObj;
        if (rule.getId() != null) {
            MailFilterWriter.writeParameter((String)"id", (int)Integer.parseInt(rule.getId()), (JSONObject)jsonObj);
        }
        MailFilterWriter.writeParameter((String)"rulename", (String)rule.getName(), (JSONObject)jsonObj);
        MailFilterWriter.writeParameter((String)"active", (boolean)rule.isActive(), (JSONObject)jsonObj);
        JSONArray flagsArray = this.getFlagsAsJSON(rule.getFlags());
        if (flagsArray != null) {
            jsonObj.put("flags", (Object)flagsArray);
        }
        if ((actionCommandObj = this.getActionCommandsAsJSON(rule.getActioncmds())) != null) {
            jsonObj.put("actioncmds", (Object)actionCommandObj);
        }
        if ((testObj = this.getTestAsJSON(rule.getTest())) != null) {
            jsonObj.put("test", (Object)testObj);
        }
    }

    public void writeMailFilterAsArray(Rule rule, JSONArray jsonArray, int[] cols) throws JSONException {
        for (int a = 0; a < cols.length; ++a) {
            this.write(cols[a], rule, jsonArray);
        }
    }

    public void write(int field, Rule rule, JSONArray jsonArray) throws JSONException {
        switch (field) {
            case 1200: {
                MailFilterWriter.writeValue((String)rule.getId(), (JSONArray)jsonArray);
                break;
            }
            case 1201: {
                MailFilterWriter.writeValue((String)rule.getName(), (JSONArray)jsonArray);
                break;
            }
            case 1202: {
                MailFilterWriter.writeValue((boolean)rule.isActive(), (JSONArray)jsonArray);
                break;
            }
            case 1204: {
                MailFilterWriter.writeValue((int)rule.getPosition(), (JSONArray)jsonArray);
                break;
            }
            case 1203: {
                JSONArray flagsArray = this.getFlagsAsJSON(rule.getFlags());
                if (flagsArray != null) {
                    jsonArray.put((Object)flagsArray);
                    break;
                }
                jsonArray.put(JSONObject.NULL);
                break;
            }
            case 1206: {
                JSONArray actionCommandObj = this.getActionCommandsAsJSON(rule.getActioncmds());
                if (actionCommandObj != null) {
                    jsonArray.put((Object)actionCommandObj);
                    break;
                }
                jsonArray.put(JSONObject.NULL);
                break;
            }
            case 1205: {
                JSONObject testObj = this.getTestAsJSON(rule.getTest());
                if (testObj != null) {
                    jsonArray.put((Object)testObj);
                    break;
                }
                jsonArray.put(JSONObject.NULL);
                break;
            }
            default: {
                LOG.warn("missing field in mapping: " + field);
            }
        }
    }

    protected JSONArray getFlagsAsJSON(String[] flags) throws JSONException {
        if (flags != null) {
            JSONArray jsonArray = new JSONArray();
            for (int a = 0; a < flags.length; ++a) {
                jsonArray.put((Object)flags[a]);
            }
            return jsonArray;
        }
        return null;
    }

    protected JSONArray getActionCommandsAsJSON(AbstractAction[] actioncmds) throws JSONException {
        if (actioncmds != null) {
            JSONArray jsonArray = new JSONArray();
            for (int a = 0; a < actioncmds.length; ++a) {
                AbstractAction abstractAction = actioncmds[a];
                String name = abstractAction.getName();
                ActionWriter actionWriter = ActionWriterFactory.getWriter(name);
                JSONObject jsonCommandObj = actionWriter.writeAction(name, abstractAction);
                jsonArray.put((Object)jsonCommandObj);
            }
            return jsonArray;
        }
        return null;
    }

    protected JSONObject getTestAsJSON(AbstractTest abstractTest) throws JSONException {
        String name = abstractTest.getName();
        TestWriter testWriter = TestWriterFactory.getWriter(name);
        return testWriter.writeTest(name, abstractTest);
    }
}

