/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.AllTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.MailMessage;
import java.io.IOException;
import javax.mail.internet.InternetAddress;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AllRequestAndResponseTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(AllTest.class);
    protected String folder;
    String mailObject_25kb;

    public AllRequestAndResponseTest(String name) throws OXException, IOException, SAXException, JSONException {
        super(name);
        this.client = new AJAXClient(AJAXClient.User.User1);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.getSentFolder();
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
        this.clearFolder(this.folder);
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.folder);
        super.tearDown();
    }

    public void testAllResponseGetMailObjects() throws Exception {
        MailMessage[] mailMessages;
        boolean numOfMails = true;
        LOG.info("Sending 1 mails to fill emptied INBOX");
        for (int i = 0; i < 1; ++i) {
            this.getClient().execute(new SendRequest(this.mailObject_25kb));
            LOG.info("Sent " + (i + 1) + ". mail of " + 1);
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            AllRequestAndResponseTest.fail((String)allR.getException().toString());
        }
        for (MailMessage mailMessage : mailMessages = allR.getMailMessages(COLUMNS_DEFAULT_LIST)) {
            AllRequestAndResponseTest.assertEquals((String)"From is not equal", (Object)new InternetAddress(this.getSendAddress()), (Object)mailMessage.getFrom()[0]);
            AllRequestAndResponseTest.assertEquals((String)"Subject is not equal", (String)"The mail subject", (String)mailMessage.getSubject());
        }
    }
}

