/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.tasks;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.ajax.kata.appointments.ParticipantComparisonFailure;
import com.openexchange.ajax.kata.appointments.UserParticipantComparisonFailure;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.ajax.task.actions.SearchRequest;
import com.openexchange.ajax.task.actions.SearchResponse;
import com.openexchange.ajax.task.actions.TaskUpdatesResponse;
import com.openexchange.ajax.task.actions.UpdatesRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.TaskTestManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class TaskVerificationStep
extends NeedExistingStep<Task> {
    private final Task entry;
    private TaskTestManager manager;
    private int expectedFolderId;

    public TaskVerificationStep(Task entry, String name) {
        super(name, null);
        this.entry = entry;
    }

    @Override
    protected void assumeIdentity(Task thing) {
        this.expectedFolderId = this.entry.getParentFolderID();
        boolean containsFolderId = this.entry.containsParentFolderID();
        super.assumeIdentity(this.entry);
        if (!containsFolderId) {
            this.expectedFolderId = this.entry.getParentFolderID();
        }
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.client = client;
        this.manager = new TaskTestManager(client);
        this.assumeIdentity(this.entry);
        this.checkWithReadMethods(this.entry);
    }

    private void checkWithReadMethods(Task task) throws OXException, JSONException, OXException, IOException, SAXException {
        this.checkViaGet(task);
        this.checkViaAll(task);
        this.checkViaList(task);
        this.checkViaUpdates(task);
        this.checkViaSearch(task);
    }

    private void checkViaGet(Task task) throws OXException, JSONException {
        Task loaded = this.manager.getTaskFromServer(this.expectedFolderId, task.getObjectID());
        this.compare(task, loaded);
    }

    private void checkViaAll(Task task) throws OXException, IOException, SAXException, JSONException {
        Object[][] rows = this.getViaAll(task);
        this.checkInList(task, rows, Task.ALL_COLUMNS);
    }

    private void checkViaList(Task task) throws OXException, IOException, SAXException, JSONException {
        ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{this.expectedFolderId, task.getObjectID()}}), Task.ALL_COLUMNS);
        CommonListResponse response = this.client.execute(listRequest);
        Object[][] rows = response.getArray();
        this.checkInList(task, rows, Task.ALL_COLUMNS);
    }

    private void checkViaUpdates(Task task) throws OXException, IOException, SAXException, JSONException, OXException {
        UpdatesRequest updates = new UpdatesRequest(this.expectedFolderId, Task.ALL_COLUMNS, 1, Order.ASCENDING, new Date(0L), this.getTimeZone());
        TaskUpdatesResponse response = this.client.execute(updates);
        List<Task> tasks = response.getTasks();
        this.checkInList(task, tasks);
    }

    private void checkViaSearch(Task task) throws OXException, IOException, SAXException, JSONException {
        Object[][] rows = this.getViaSearch(task);
        this.checkInList(task, rows, Task.ALL_COLUMNS);
    }

    private Object[][] getViaAll(Task task) throws OXException, IOException, SAXException, JSONException {
        AllRequest all = new AllRequest(this.expectedFolderId, Task.ALL_COLUMNS, 1, Order.ASCENDING);
        CommonAllResponse response = this.client.execute(all);
        return response.getArray();
    }

    private Object[][] getViaSearch(Task task) throws OXException, IOException, SAXException, JSONException {
        TaskSearchObject searchObject = new TaskSearchObject();
        searchObject.addFolder(this.expectedFolderId);
        searchObject.setPattern("*");
        SearchRequest searchRequest = new SearchRequest(searchObject, Task.ALL_COLUMNS);
        SearchResponse searchResponse = this.client.execute(searchRequest);
        return searchResponse.getArray();
    }

    private void compare(Task task, Task loaded) {
        int[] columns = Task.ALL_COLUMNS;
        for (int i = 0; i < columns.length; ++i) {
            Participant[] actual;
            Participant[] expected;
            int col = columns[i];
            if (col == 6 || col == 5) continue;
            if (col == 220 && task.containsParticipants()) {
                expected = task.getParticipants();
                if (this.compareArrays(expected, actual = loaded.getParticipants())) continue;
                throw new ParticipantComparisonFailure("", expected, actual);
            }
            if (col == 221 && task.containsUserParticipants()) {
                expected = task.getUsers();
                if (this.compareArrays(expected, actual = loaded.getUsers())) continue;
                throw new UserParticipantComparisonFailure("", (UserParticipant[])expected, (UserParticipant[])actual);
            }
            if (!task.contains(col)) continue;
            Assert.assertEquals((String)(this.name + ": Column " + col + " differs!"), (Object)task.get(col), (Object)loaded.get(col));
        }
    }

    private void checkInList(Task task, Object[][] rows, int[] columns) throws OXException, IOException, SAXException, JSONException {
        int idPos = this.findIDIndex(columns);
        for (int i = 0; i < rows.length; ++i) {
            Object[] row = rows[i];
            int id = (Integer)row[idPos];
            if (id != task.getObjectID()) continue;
            this.compare(task, row, columns);
            return;
        }
        Assert.fail((String)("Object not found in response. " + this.name));
    }

    private void compare(Task task, Object[] row, int[] columns) throws OXException, IOException, SAXException, JSONException {
        for (int i = 0; i < columns.length; ++i) {
            Object actual;
            Object expected;
            int column = columns[i];
            if (column == 6 || column == 5) continue;
            if (column == 220 && task.containsParticipants()) {
                expected = task.getParticipants();
                if (this.compareArrays((T[])expected, (T[])(actual = (Participant[])this.transform(column, row[i])))) continue;
                throw new ParticipantComparisonFailure("", (Participant[])expected, (Participant[])actual);
            }
            if (column == 221 && task.containsUserParticipants()) {
                expected = task.getUsers();
                if (this.compareArrays((T[])expected, (T[])(actual = (UserParticipant[])this.transform(column, row[i])))) continue;
                throw new UserParticipantComparisonFailure("", (UserParticipant[])expected, (UserParticipant[])actual);
            }
            if (!task.contains(column)) continue;
            expected = task.get(column);
            actual = row[i];
            actual = this.transform(column, actual);
            Assert.assertEquals((String)(this.name + " Column: " + column), (Object)expected, (Object)actual);
        }
    }

    protected <T> boolean compareArrays(T[] expected, T[] actual) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null && actual != null) {
            return false;
        }
        if (expected != null && actual == null) {
            return false;
        }
        HashSet<T> expectedParticipants = new HashSet<T>(Arrays.asList(expected));
        HashSet<T> actualParticipants = new HashSet<T>(Arrays.asList(actual));
        if (expectedParticipants.size() != actualParticipants.size()) {
            return false;
        }
        return expectedParticipants.containsAll(actualParticipants);
    }

    private void checkInList(Task task, List<Task> tasks) {
        for (Task taskFromList : tasks) {
            if (taskFromList.getObjectID() != task.getObjectID()) continue;
            this.compare(task, taskFromList);
            return;
        }
        Assert.fail((String)("Object not found in response. " + this.name));
    }

    private int findIDIndex(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != 1) continue;
            return i;
        }
        Assert.fail((String)("No ID column requested. This won't work. " + this.name));
        return -1;
    }

    private Object transform(int column, Object actual) throws OXException, IOException, SAXException, JSONException {
        switch (column) {
            case 201: 
            case 202: {
                return new Date((Long)actual);
            }
            case 220: {
                JSONArray participantArr = (JSONArray)actual;
                LinkedList<Object> participants = new LinkedList<Object>();
                int size = participantArr.length();
                block10: for (int i = 0; i < size; ++i) {
                    JSONObject participantObj = participantArr.getJSONObject(i);
                    int type = participantObj.getInt("type");
                    switch (type) {
                        case 1: {
                            participants.add(new UserParticipant(participantObj.getInt("id")));
                            continue block10;
                        }
                        case 2: {
                            participants.add(new GroupParticipant(participantObj.getInt("id")));
                            continue block10;
                        }
                        case 5: {
                            participants.add(new ExternalUserParticipant(participantObj.getString("mail")));
                        }
                    }
                }
                return participants.toArray(new Participant[participants.size()]);
            }
            case 221: {
                JSONArray userParticipantArr = (JSONArray)actual;
                LinkedList<UserParticipant> userParticipants = new LinkedList<UserParticipant>();
                int size = userParticipantArr.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject participantObj = userParticipantArr.getJSONObject(i);
                    userParticipants.add(new UserParticipant(participantObj.getInt("id")));
                }
                return userParticipants.toArray(new UserParticipant[userParticipants.size()]);
            }
        }
        return actual;
    }

    @Override
    public void cleanUp() throws Exception {
    }
}

