/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.tasks;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.TaskTestManager;
import org.junit.Assert;

public class TaskDeleteStep
extends NeedExistingStep<Task> {
    private final Task entry;

    public TaskDeleteStep(Task entry, String name, String expectedError) {
        super(name, expectedError);
        this.entry = entry;
    }

    @Override
    public void cleanUp() throws Exception {
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.assumeIdentity(this.entry);
        TaskTestManager manager = new TaskTestManager(client);
        manager.setFailOnError(!this.expectsError());
        if (!this.expectsError()) {
            Assert.assertNotNull((String)"Should have found task before deletion", (Object)manager.getTaskFromServer(this.entry));
        }
        DeleteRequest request = new DeleteRequest(this.entry, !this.expectsError());
        CommonDeleteResponse response = client.execute(request);
        this.checkError(response);
        if (!this.expectsError()) {
            boolean old = manager.getFailOnError();
            manager.setFailOnError(false);
            Assert.assertNull((String)"Should not have found task after deletion", (Object)manager.getTaskFromServer(this.entry));
            manager.setFailOnError(old);
        }
        if (!response.hasError()) {
            this.forgetIdentity(this.entry);
        }
    }
}

