/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.SearchInfostoreResponse;
import com.openexchange.groupware.search.Order;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchInfostoreRequest
extends AbstractInfostoreRequest<SearchInfostoreResponse> {
    final long folderId;
    final String title;
    final int[] columns;
    final int sort;
    final Order order;
    final boolean failOnError;

    public SearchInfostoreRequest(String title, int[] columns) {
        this(-1L, title, columns, true);
    }

    public SearchInfostoreRequest(long folderId, String title, int[] columns) {
        this(folderId, title, columns, true);
    }

    public SearchInfostoreRequest(long folderId, String title, int[] columns, boolean failOnError) {
        this(folderId, title, columns, 0, null, failOnError);
    }

    public SearchInfostoreRequest(long folderId, String title, int[] columns, int sort, Order order) {
        this(folderId, title, columns, sort, order, true);
    }

    public SearchInfostoreRequest(long folderId, String title, int[] columns, int sort, Order order, boolean failOnError) {
        this.folderId = folderId;
        this.title = title;
        this.columns = columns;
        this.sort = sort;
        this.order = order;
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject json = new JSONObject();
        if (-1L != this.folderId) {
            json.put("folder", this.folderId);
        }
        json.put("pattern", (Object)this.title);
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> params = new ArrayList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "search"));
        params.add(new AJAXRequest.Parameter("columns", this.columns));
        if (null != this.order) {
            params.add(new AJAXRequest.Parameter("sort", this.sort));
            params.add(new AJAXRequest.Parameter("order", OrderFields.write((Order)this.order)));
        }
        return params.toArray(new AJAXRequest.Parameter[params.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends SearchInfostoreResponse> getParser() {
        return new AbstractAJAXParser<SearchInfostoreResponse>(this.failOnError){

            @Override
            protected SearchInfostoreResponse createResponse(Response response) {
                return new SearchInfostoreResponse(response);
            }
        };
    }
}

