/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.test.TestInit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class NewTest
extends InfostoreAJAXTest {
    public static final int SIZE = 15;
    private static final byte[] megabyte = new byte[1000000];

    public NewTest(String name) {
        super(name);
    }

    public void testNothing() {
        NewTest.assertTrue((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpload() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test upload", "description", "test upload description"), upload, "text/plain");
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        NewTest.assertNotNull((Object)res.getTimestamp());
        JSONObject obj = (JSONObject)res.getData();
        NewTest.assertEquals((String)"test upload", (String)obj.getString("title"));
        NewTest.assertEquals((String)"test upload description", (String)obj.getString("description"));
        NewTest.assertEquals((int)1, (int)obj.getInt("version"));
        NewTest.assertEquals((String)"text/plain", (String)obj.getString("file_mimetype"));
        NewTest.assertEquals((String)upload.getName(), (String)obj.getString("filename"));
        FileInputStream is = null;
        InputStream is2 = null;
        try {
            is = new FileInputStream(upload);
            is2 = this.document(this.getWebConversation(), this.getHostName(), this.sessionId, id, 1);
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
        id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test no upload", "description", "test no upload description"), null, "");
        this.clean.add(id);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        obj = (JSONObject)res.getData();
        NewTest.assertEquals((String)"test no upload", (String)obj.getString("title"));
        NewTest.assertEquals((String)"test no upload description", (String)obj.getString("description"));
    }

    public void testUploadEmptyFile() throws IOException, JSONException, SAXException {
        File emptyFile = File.createTempFile("infostore-new-test", ".txt");
        int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test upload", "description", "test upload description"), emptyFile, "text/plain");
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        NewTest.assertNotNull((Object)res.getTimestamp());
        JSONObject obj = (JSONObject)res.getData();
        NewTest.assertEquals((String)"test upload", (String)obj.getString("title"));
        NewTest.assertEquals((String)"test upload description", (String)obj.getString("description"));
        NewTest.assertEquals((int)1, (int)obj.getInt("version"));
        NewTest.assertEquals((String)"text/plain", (String)obj.getString("file_mimetype"));
        NewTest.assertEquals((String)emptyFile.getName(), (String)obj.getString("filename"));
        NewTest.assertTrue((boolean)emptyFile.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeFileUpload() throws Exception {
        File largeFile = File.createTempFile("test", "bin");
        largeFile.deleteOnExit();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(largeFile), 1000000);
            for (int i = 0; i < 15; ++i) {
                out.write(megabyte);
                ((BufferedOutputStream)out).flush();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        try {
            int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test large upload", "description", "test large upload description"), largeFile, "text/plain");
            this.clean.add(id);
            NewTest.fail((String)"Uploaded Large File and got no error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testVersionCommentForNewDocument() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString(), "title", "test upload", "description", "test upload description", "version_comment", "Version Comment"), upload, "text/plain");
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        JSONObject obj = (JSONObject)res.getData();
        NewTest.assertEquals((int)1, (int)obj.getInt("version"));
        NewTest.assertEquals((String)"Version Comment", (String)obj.getString("version_comment"));
    }

    public void testUniqueFilenamesOnUpload() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
        NewTest.assertNoError(res);
        int id2 = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("title", "otherFile", "description", "other_desc", "folder_id", Integer.valueOf(this.folderId).toString()), upload, "text/plain");
        this.clean.add(id2);
        res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id2);
        JSONObject obj = (JSONObject)res.getData();
        NewTest.assertFalse((boolean)upload.getName().equals(obj.get("filename")));
    }

    public void testVirtualFolder() throws Exception {
        for (int folderId : virtualFolders) {
            this.virtualFolder(folderId);
        }
    }

    public void virtualFolder(int folderId) throws Exception {
        try {
            this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", "" + folderId));
            NewTest.fail((String)"Expected exception because we can't create a document in this virtual folder");
        }
        catch (JSONException x) {
            NewTest.assertTrue((String)x.getMessage(), (boolean)x.getMessage().contains("virt"));
        }
    }

    public void testTitleFromFilename() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString()), upload, "text/plain");
        this.clean.add(id);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        JSONObject obj = (JSONObject)res.getData();
        NewTest.assertEquals((String)upload.getName(), (String)obj.getString("title"));
    }

    public void testTitleFromFilenameTheSameEvenIfFilenameIsChangedOnCollision() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString()), upload, "text/plain");
        this.clean.add(id);
        int id2 = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("folder_id", Integer.valueOf(this.folderId).toString()), upload, "text/plain");
        this.clean.add(id2);
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id2);
        JSONObject obj = (JSONObject)res.getData();
        NewTest.assertEquals((String)obj.getString("filename"), (String)obj.getString("title"));
    }
}

