/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Appointment;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;

public class ICalSeriesTests
extends ManagedAppointmentTest {
    public ICalSeriesTests(String name) {
        super(name);
    }

    public void testDeleteException() throws OXException, IOException, JSONException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nBEGIN:VEVENT\nDTSTART;TZID=Europe/Rome:20100202T103000\nDTEND;TZID=Europe/Rome:20100202T120000\nRRULE:FREQ=DAILY;UNTIL=20100204T215959Z\nEXDATE:20100203T103000\nDTSTAMP:20110105T174810Z\nSUMMARY:Exceptional Meeting #1\nEND:VEVENT\n";
        AJAXClient client = this.getClient();
        int fid = this.folder.getObjectID();
        TimeZone tz = client.getValues().getTimeZone();
        ICalImportRequest request = new ICalImportRequest(fid, ical);
        client.execute(request);
        AllRequest allRequest = new AllRequest(fid, Appointment.ALL_COLUMNS, this.D("2010-02-03 00:00", tz), this.D("2010-02-04 00:00", tz), tz, false);
        CommonAllResponse response2 = client.execute(allRequest);
        Object[][] data = response2.getArray();
        ICalSeriesTests.assertEquals((int)0, (int)data.length);
    }

    public void testChangeExceptionWithExceptionFirst() throws Exception {
        String uid = "change-exception-" + new Date().getTime();
        String title = "Change to exceptional meeting #3: One hour later";
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nBEGIN:VEVENT\nDTSTART;TZID=Europe/Rome:20100204T113000\nDTEND;TZID=Europe/Rome:20100204T130000\nDTSTAMP:20110105T174810Z\nSUMMARY:" + title + "\n" + "UID:" + uid + "\n" + "END:VEVENT\n" + "BEGIN:VEVENT\n" + "DTSTART;TZID=Europe/Rome:20100202T103000\n" + "DTEND;TZID=Europe/Rome:20100202T120000\n" + "RRULE:FREQ=DAILY;UNTIL=20100228T215959Z\n" + "DTSTAMP:20110105T174810Z\n" + "SUMMARY:Exceptional meeting #3\n" + "UID:" + uid + "\n" + "END:VEVENT\n";
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Date start = this.D("2010-02-04 00:00", tz);
        Date end = this.D("2010-02-05 00:00", tz);
        this.testChangeException(ical, title, start, end);
    }

    public void testChangeExceptionWithMasterFirst() throws Exception {
        String uid = "change-exception-" + new Date().getTime();
        String title = "Change to exceptional meeting #2: Five hours later";
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nBEGIN:VEVENT\nDTSTART;TZID=Europe/Rome:20100202T110000\nDTEND;TZID=Europe/Rome:20100202T120000\nRRULE:FREQ=DAILY;UNTIL=20100228T215959Z\nDTSTAMP:20110105T174810Z\nSUMMARY:Exceptional meeting #2\nUID:" + uid + "\n" + "END:VEVENT\n" + "BEGIN:VEVENT\n" + "DTSTART;TZID=Europe/Rome:20100204T160000\n" + "DTEND;TZID=Europe/Rome:20100204T170000\n" + "DTSTAMP:20110105T174810Z\n" + "SUMMARY:" + title + "\n" + "UID:" + uid + "\n" + "END:VEVENT\n";
        TimeZone tz = TimeZone.getTimeZone("GMT");
        Date start = this.D("2010-02-04 00:00", tz);
        Date end = this.D("2010-02-05 00:00", tz);
        this.testChangeException(ical, title, start, end);
    }

    protected void testChangeException(String ical, String expectedTitle, Date start, Date end) throws Exception {
        AJAXClient client = this.getClient();
        int fid = this.folder.getObjectID();
        TimeZone tz = client.getValues().getTimeZone();
        ICalImportRequest request = new ICalImportRequest(fid, ical);
        client.execute(request);
        AllRequest allRequest = new AllRequest(fid, new int[]{1}, start, end, tz, false);
        CommonAllResponse response2 = client.execute(allRequest);
        Object[][] data = response2.getArray();
        ICalSeriesTests.assertEquals((int)1, (int)data.length);
        int oid = (Integer)data[0][response2.getColumnPos(ContactField.OBJECT_ID.getNumber())];
        GetRequest getRequest = new GetRequest(fid, oid);
        GetResponse getResponse = client.execute(getRequest);
        Appointment actual = getResponse.getAppointment(tz);
        ICalSeriesTests.assertEquals((String)expectedTitle, (String)actual.getTitle());
    }
}

