/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LogoutRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;

public class AJAXClient {
    public static final String VERSION = "7.4.2";
    private final AJAXSession session;
    private final UserValues values = new UserValues(this);
    private boolean mustLogout;
    private String hostname = null;
    private String protocol = null;

    public AJAXClient(AJAXSession session, boolean logout) {
        this.session = session;
        this.mustLogout = logout;
    }

    public AJAXClient(User user) throws OXException, OXException, IOException, JSONException {
        String password;
        AJAXConfig.init();
        String login = AJAXConfig.getProperty(user.getLogin());
        if (null == login) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getLogin().getPropertyName()});
        }
        if (!login.contains("@")) {
            String context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
            if (null == context) {
                throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{AJAXConfig.Property.CONTEXTNAME.getPropertyName()});
            }
            login = login + "@" + context;
        }
        if (null == (password = AJAXConfig.getProperty(user.getPassword()))) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{user.getPassword().getPropertyName()});
        }
        this.session = new AJAXSession();
        this.session.setId(this.execute(new LoginRequest(login, password, LoginTools.generateAuthId(), AJAXClient.class.getName(), VERSION)).getSessionId());
    }

    public AJAXClient() throws OXException {
        AJAXConfig.init();
        this.session = new AJAXSession();
    }

    public AJAXSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mustLogout) {
                this.logout();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void logout() throws OXException, IOException, JSONException {
        if (null != this.session.getId()) {
            this.execute(new LogoutRequest());
            this.session.setId(null);
        }
        this.session.getConversation().clearContents();
        this.session.getHttpClient().getConnectionManager().shutdown();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public UserValues getValues() {
        return this.values;
    }

    public <T extends AbstractAJAXResponse> T execute(AJAXRequest<T> request, int sleep) throws OXException, IOException, JSONException {
        if (this.hostname != null && this.protocol != null) {
            if (sleep != -1) {
                return Executor.execute(this.getSession(), request, this.getProtocol(), this.getHostname(), sleep);
            }
            return Executor.execute(this.getSession(), request, this.getProtocol(), this.getHostname());
        }
        return Executor.execute(this, request);
    }

    public <T extends AbstractAJAXResponse> T execute(AJAXRequest<T> request) throws OXException, IOException, JSONException {
        return this.execute(request, -1);
    }

    public <T extends AbstractAJAXResponse> T executeSafe(AJAXRequest<T> request) {
        try {
            return this.execute(request, -1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum User {
        User1(AJAXConfig.Property.LOGIN, AJAXConfig.Property.PASSWORD),
        User2(AJAXConfig.Property.SECONDUSER, AJAXConfig.Property.PASSWORD),
        User3(AJAXConfig.Property.THIRDLOGIN, AJAXConfig.Property.PASSWORD),
        User4(AJAXConfig.Property.FOURTHLOGIN, AJAXConfig.Property.PASSWORD),
        OXAdmin(AJAXConfig.Property.OXADMIN, AJAXConfig.Property.PASSWORD);

        private AJAXConfig.Property login;
        private AJAXConfig.Property password;

        private User(AJAXConfig.Property login, AJAXConfig.Property password) {
            this.login = login;
            this.password = password;
        }

        public AJAXConfig.Property getLogin() {
            return this.login;
        }

        public AJAXConfig.Property getPassword() {
            return this.password;
        }
    }
}

