/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.PathRequest;
import com.openexchange.ajax.folder.actions.PathResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.PermissionTools;
import java.util.Date;

public class Bug15980Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private FolderObject testFolder;

    public Bug15980Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.testFolder = new FolderObject();
        this.testFolder.setModule(2);
        this.testFolder.setParentFolderID(2);
        this.testFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.client.getValues().getUserId()), "arawada/a"));
        this.testFolder.setFolderName("testFolder4Bug15980");
        InsertRequest iReq = new InsertRequest(EnumAPI.OUTLOOK, this.testFolder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.testFolder);
        this.testFolder.setLastModified(new Date());
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.testFolder));
        super.tearDown();
    }

    public void testPath() throws Throwable {
        PathRequest request = new PathRequest((API)EnumAPI.OUTLOOK, this.testFolder.getObjectID(), new int[]{1, 300});
        PathResponse response = this.client.execute(request);
        Object[][] objects = response.getArray();
        int idPos = response.getColumnPos(1);
        Bug15980Test.assertTrue((String)"Response should contain folder identifier.", (idPos >= 0 ? 1 : 0) != 0);
        int namePos = response.getColumnPos(300);
        Bug15980Test.assertTrue((String)"Response should contain folder names.", (namePos >= 0 ? 1 : 0) != 0);
        Bug15980Test.assertEquals((String)"Path on Outlook like tree should have 3 parts.", (int)3, (int)objects.length);
        Bug15980Test.assertEquals((String)("Path should start with test folder but is folder " + objects[0][namePos]), (Object)Integer.toString(this.testFolder.getObjectID()), (Object)objects[0][idPos]);
        Bug15980Test.assertEquals((String)("Parent of created folder should be public folders but is " + objects[1][namePos]), (Object)FolderStorage.PUBLIC_ID, (Object)objects[1][idPos]);
        Bug15980Test.assertEquals((String)("Root folder should be IPM_ROOT but is " + objects[2][namePos]), (Object)FolderStorage.PRIVATE_ID, (Object)objects[2][idPos]);
    }
}

