/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.ContactUpdatesResponse;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.UpdatesRequest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.container.Contact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdatesTest
extends AbstractContactTest {
    public UpdatesTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testUpdates() throws Exception {
        int numberofcontacts = 8;
        Contact[] newContacts = this.createSeveralContacts("updates", "contact", 8);
        MultipleResponse<InsertResponse> insertResponses = this.createMultipleInsertRequest(newContacts);
        this.updateContactsWithTimeAndId(newContacts, insertResponses);
        Contact[] expectUpdatedContacts = new Contact[]{newContacts[0], newContacts[1]};
        Integer[] expectUpdatedContactIds = new Integer[]{newContacts[0].getObjectID(), newContacts[1].getObjectID()};
        this.updateContacts(expectUpdatedContacts);
        Contact[] expectDeletedContacts = new Contact[]{newContacts[2], newContacts[3]};
        Integer[] expectDeletedContactIds = new Integer[]{newContacts[2].getObjectID(), newContacts[3].getObjectID()};
        this.deleteContacts(expectDeletedContacts);
        Date lastModified = newContacts[7].getLastModified();
        ContactUpdatesResponse modifiedContactsResponse = this.listModifiedContacts(this.contactFolderId, new int[]{1, 501, 502, 500}, lastModified, AbstractUpdatesRequest.Ignore.NONE);
        UpdatesTest.assertTrue((boolean)modifiedContactsResponse.getNewOrModifiedIds().containsAll(Arrays.asList(expectUpdatedContactIds)));
        UpdatesTest.assertTrue((boolean)modifiedContactsResponse.getDeletedIds().containsAll(Arrays.asList(expectDeletedContactIds)));
        ArrayList<Contact> contactsToDelete = new ArrayList<Contact>(8 - expectDeletedContacts.length);
        for (int i = 0; i < newContacts.length; ++i) {
            List<Integer> deletedIds = Arrays.asList(expectDeletedContactIds);
            if (deletedIds.contains(newContacts[i].getObjectID())) continue;
            contactsToDelete.add(newContacts[i]);
        }
        this.deleteContacts(contactsToDelete.toArray(new Contact[contactsToDelete.size()]));
    }

    private void updateContactsWithTimeAndId(Contact[] contacts, MultipleResponse<InsertResponse> insertResponses) throws Exception {
        for (int i = 0; i < contacts.length; ++i) {
            Response response = insertResponses.getResponse(i).getResponse();
            Date timestamp = response.getTimestamp();
            JSONObject responseData = (JSONObject)response.getData();
            contacts[i].setLastModified(timestamp);
            contacts[i].setObjectID(responseData.getInt("id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        int[] cols = new int[]{1, 20, 6};
        Contact contactObj = this.createContactObject("testLastModifiedUTC");
        int objectId = this.insertContact(contactObj);
        try {
            UpdatesRequest updatesRequest = new UpdatesRequest(this.contactFolderId, cols, -1, null, new Date(0L));
            ContactUpdatesResponse response = this.client.execute(updatesRequest);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            UpdatesTest.assertNotNull((Object)arr);
            int size = arr.length();
            UpdatesTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                UpdatesTest.assertNotNull((Object)objectData);
                UpdatesTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            try {
                this.deleteContact(objectId, this.contactFolderId, true);
            }
            catch (Exception e) {}
        }
    }
}

