/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.AdvancedSearchRequest;
import com.openexchange.ajax.framework.CommonSearchResponse;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.ContactTestManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class AdvancedSearchTest
extends AbstractManagedContactTest {
    private static final String BOB_LASTNAME = "Rather complicated last name with timestamp (" + new Date().getTime() + ") that does not appear in other folders";

    public AdvancedSearchTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Contact alice = ContactTestManager.generateContact(this.folderID);
        alice.setGivenName("Alice");
        Contact bob = ContactTestManager.generateContact(this.folderID);
        bob.setGivenName("Bob");
        bob.setSurName(BOB_LASTNAME);
        Contact charlie = ContactTestManager.generateContact(this.folderID);
        charlie.setGivenName("Charlie");
        this.manager.newAction(alice, bob, charlie);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSearchWithEquals() throws Exception {
        ContactField field = ContactField.GIVEN_NAME;
        ContactField folderField = ContactField.FOLDER_ID;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['=' , {'field' : '" + field.getAjaxName() + "'} , 'Bob'], " + "['=' , {'field' : '" + folderField.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{501}, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)"Bob", (String)actual);
    }

    public void testSearchWithEqualsInAllFolders() throws Exception {
        ContactField field = ContactField.SUR_NAME;
        JSONObject filter = new JSONObject("{'filter' : [ '=' , {'field' : '" + field.getAjaxName() + "'} , '" + BOB_LASTNAME + "']}");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, Contact.ALL_COLUMNS, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)BOB_LASTNAME, (String)actual);
    }

    public void testLittleBobbyTables() throws Exception {
        ContactField field = ContactField.SUR_NAME;
        String bobby = "Robert\\\"); DROP TABLE prg_contacts; --";
        JSONObject filter = new JSONObject("{'filter' : [ 'or', ['=' , {'field' : '" + field.getAjaxName() + "'} , '" + BOB_LASTNAME + "'], " + "['=' , {'field' : '" + field.getAjaxName() + "'}, '" + bobby + "']" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, Contact.ALL_COLUMNS, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)BOB_LASTNAME, (String)actual);
    }

    public void testSearchAlphabetRange() throws Exception {
        ContactField field = ContactField.GIVEN_NAME;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['>=' , {'field' : '" + field.getAjaxName() + "'} , 'A'], " + "['<' , {'field' : '" + field.getAjaxName() + "'}, 'C'], " + "['=' , {'field' : '" + ContactField.FOLDER_ID.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find at least a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find two results", (int)2, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        HashSet<String> names = new HashSet<String>();
        names.add((String)resultTable[0][columnPos]);
        names.add((String)resultTable[1][columnPos]);
        AdvancedSearchTest.assertTrue((boolean)names.contains("Bob"));
        AdvancedSearchTest.assertTrue((boolean)names.contains("Alice"));
    }

    public void testSearchOrdering() throws Exception {
        this.manager.newAction(ContactTestManager.generateContact(this.folderID, "Elvis"), ContactTestManager.generateContact(this.folderID, "Feelvis"), ContactTestManager.generateContact(this.folderID, "Gelvis"), ContactTestManager.generateContact(this.folderID, "Geena"), ContactTestManager.generateContact(this.folderID, "Hellvis"));
        ContactField field = ContactField.SUR_NAME;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['>=' , {'field' : '" + field.getAjaxName() + "'} , 'E'], " + "['<' , {'field' : '" + field.getAjaxName() + "'}, 'I'], " + "['NOT' , ['=' , {'field' : '" + field.getAjaxName() + "'}, 'Geena']], " + "['=' , {'field' : '" + ContactField.FOLDER_ID.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, field.getNumber(), "asc");
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find at least a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find four results", (int)4, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[0][columnPos].equals("Elvis"));
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[1][columnPos].equals("Feelvis"));
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[2][columnPos].equals("Gelvis"));
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[3][columnPos].equals("Hellvis"));
        request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, field.getNumber(), "desc");
        response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find at least a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find four results", (int)4, (int)resultTable.length);
        columnPos = response.getColumnPos(field.getNumber());
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[0][columnPos].equals("Hellvis"));
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[1][columnPos].equals("Gelvis"));
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[2][columnPos].equals("Feelvis"));
        AdvancedSearchTest.assertTrue((String)"Result should appear in the right order", (boolean)resultTable[3][columnPos].equals("Elvis"));
    }

    public void testSearchOrderingWithKana() throws Exception {
        this.manager.newAction(ContactTestManager.generateContact(this.folderID, "\u30ef"), ContactTestManager.generateContact(this.folderID, "\u30ea"), ContactTestManager.generateContact(this.folderID, "\u30e9"), ContactTestManager.generateContact(this.folderID, "\u30e5"), ContactTestManager.generateContact(this.folderID, "\u30e4"), ContactTestManager.generateContact(this.folderID, "\u30df"), ContactTestManager.generateContact(this.folderID, "\u30de"), ContactTestManager.generateContact(this.folderID, "\u30d0"), ContactTestManager.generateContact(this.folderID, "\u30cf"), ContactTestManager.generateContact(this.folderID, "\u30cb"), ContactTestManager.generateContact(this.folderID, "\u30ca"), ContactTestManager.generateContact(this.folderID, "\u30c0"), ContactTestManager.generateContact(this.folderID, "\u30bf"), ContactTestManager.generateContact(this.folderID, "\u30b6"), ContactTestManager.generateContact(this.folderID, "\u30b5"), ContactTestManager.generateContact(this.folderID, "\u30ac"), ContactTestManager.generateContact(this.folderID, "\u30ab"), ContactTestManager.generateContact(this.folderID, "\u30a3"), ContactTestManager.generateContact(this.folderID, "\u30a2"));
        String[] letters = new String[]{"\u30a2", "\u30ab", "\u30b5", "\u30bf", "\u30ca", "\u30cf", "\u30de", "\u30e4", "\u30e9", "\u30ef"};
        ContactField field = ContactField.SUR_NAME;
        LinkedList<JSONObject> filters = new LinkedList<JSONObject>();
        for (int i = 0; i < letters.length - 1; ++i) {
            filters.add(new JSONObject("{'filter' : [ 'and', ['>=' , {'field' : '" + field.getAjaxName() + "'} , '" + letters[i] + "'], " + "['<' , {'field' : '" + field.getAjaxName() + "'}, '" + letters[i + 1] + "'], " + "['=' , {'field' : '" + ContactField.FOLDER_ID.getAjaxName() + "'}, " + this.folderID + "]" + "]})"));
        }
        int currentPosition = 0;
        for (JSONObject filter : filters) {
            String ident = "Step #" + currentPosition + " from " + letters[currentPosition] + " to " + letters[currentPosition + 1] + ": ";
            AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, field.getNumber(), "asc");
            CommonSearchResponse response = this.getClient().execute(request);
            AdvancedSearchTest.assertFalse((String)(ident + "Should work"), (boolean)response.hasError());
            Object[][] resultTable = response.getArray();
            AdvancedSearchTest.assertNotNull((String)(ident + "Should find at least a result"), (Object)resultTable);
            AdvancedSearchTest.assertEquals((String)(ident + "Should find two results"), (int)2, (int)resultTable.length);
            int columnPos = response.getColumnPos(field.getNumber());
            HashSet<String> names = new HashSet<String>();
            names.add((String)resultTable[0][columnPos]);
            names.add((String)resultTable[1][columnPos]);
            AdvancedSearchTest.assertTrue((String)(ident + "Should be contained"), (boolean)names.contains(letters[currentPosition]));
            ++currentPosition;
        }
    }

    public void testSearchOrderingWithHanzi() throws Exception {
        List<String> sinograph = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01", "\u79d1", "\u4e86", "\u4e48", "\u5462", "\u54e6", "\u6279", "\u4e03", "\u5982", "\u56db", "\u8e22", "\u5c4b", "\u897f", "\u8863", "\u5b50");
        for (String graphem : sinograph) {
            this.manager.newAction(ContactTestManager.generateContact(this.folderID, graphem));
        }
        ContactField field = ContactField.SUR_NAME;
        LinkedList<JSONObject> filters = new LinkedList<JSONObject>();
        for (int i = 0; i < sinograph.size() - 1; ++i) {
            filters.add(new JSONObject("{'filter' : [ 'and', ['>=' , {'field' : '" + field.getAjaxName() + "'} , '" + sinograph.get(i) + "'], " + "['<' , {'field' : '" + field.getAjaxName() + "'}, '" + sinograph.get(i + 1) + "'], " + "['=' , {'field' : '" + ContactField.FOLDER_ID.getAjaxName() + "'}, " + this.folderID + "]" + "]})"));
        }
        int currentPosition = 0;
        for (JSONObject filter : filters) {
            String ident = "Step #" + currentPosition + " from " + sinograph.get(currentPosition) + " to " + sinograph.get(currentPosition + 1) + ": ";
            AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, field.getNumber(), "asc", "gb2312");
            CommonSearchResponse response = this.getClient().execute(request);
            AdvancedSearchTest.assertFalse((String)(ident + "Should work"), (boolean)response.hasError());
            Object[][] resultTable = response.getArray();
            AdvancedSearchTest.assertNotNull((String)(ident + "Should find at least a result"), (Object)resultTable);
            AdvancedSearchTest.assertEquals((String)(ident + "Should find one result"), (int)1, (int)resultTable.length);
            int columnPos = response.getColumnPos(field.getNumber());
            String actualName = (String)resultTable[0][columnPos];
            AdvancedSearchTest.assertEquals((String)(ident + "Should be contained"), (String)sinograph.get(currentPosition), (String)actualName);
            ++currentPosition;
        }
    }

    public void testOrderByWithCollation() throws Exception {
        int i;
        ContactField field = ContactField.SUR_NAME;
        List<String> sinograph = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01", "\u79d1", "\u4e86", "\u4e48", "\u5462", "\u54e6", "\u6279", "\u4e03", "\u5982", "\u56db", "\u8e22", "\u5c4b", "\u897f", "\u8863", "\u5b50");
        LinkedList<String> randomized = new LinkedList<String>(sinograph);
        Collections.shuffle(randomized);
        for (String graphem : randomized) {
            this.manager.newAction(ContactTestManager.generateContact(this.folderID, graphem));
        }
        JSONObject filter = new JSONObject("{'filter' : [ '>=' , {'field':'" + field.getAjaxName() + "'}, '\u963f' ]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, field.getNumber(), "asc", "gb2312");
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find at least a result", (Object)resultTable);
        int columnPos = response.getColumnPos(field.getNumber());
        LinkedList<String> actuals = new LinkedList<String>();
        for (i = 0; i < resultTable.length; ++i) {
            String actualName = (String)resultTable[i][columnPos];
            actuals.add(actualName);
        }
        for (i = 0; i < actuals.size(); ++i) {
            AdvancedSearchTest.assertEquals((String)("Graphen #" + i + " is wrong"), (String)sinograph.get(i), (String)((String)actuals.get(i)));
        }
    }

    public void testNameThatAppearedTwice() throws Exception {
        String name = "\u7802\u7cd6";
        this.manager.newAction(ContactTestManager.generateContact(this.folderID, name));
        ContactField field = ContactField.SUR_NAME;
        List<String> sinograph = Arrays.asList("\u963f", "\u6ce2", "\u6b21", "\u7684", "\u9e45", "\u5bcc", "\u54e5", "\u6cb3", "\u6d01", "\u79d1", "\u4e86", "\u4e48", "\u5462", "\u54e6", "\u6279", "\u4e03", "\u5982", "\u56db", "\u8e22", "\u5c4b", "\u897f", "\u8863", "\u5b50");
        LinkedList<JSONObject> filters = new LinkedList<JSONObject>();
        for (int i = 0; i < sinograph.size() - 1; ++i) {
            filters.add(new JSONObject("{'filter' : [ 'and', ['>=' , {'field' : '" + field.getAjaxName() + "'} , '" + sinograph.get(i) + "'], " + "['<' , {'field' : '" + field.getAjaxName() + "'}, '" + sinograph.get(i + 1) + "'], " + "['=' , {'field' : '" + ContactField.FOLDER_ID.getAjaxName() + "'}, " + this.folderID + "]" + "]})"));
        }
        int occurences = 0;
        for (JSONObject filter : filters) {
            AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{field.getNumber()}, field.getNumber(), "asc", "gb2312");
            CommonSearchResponse response = this.getClient().execute(request);
            Object[][] resultTable = response.getArray();
            occurences += resultTable.length;
        }
        AdvancedSearchTest.assertEquals((String)"Should only appear once", (int)1, (int)occurences);
    }

    public void testQuestionmarkWildcardInTheBeginning() throws Exception {
        ContactField field = ContactField.GIVEN_NAME;
        ContactField folderField = ContactField.FOLDER_ID;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['=' , {'field' : '" + field.getAjaxName() + "'} , '?ob'], " + "['=' , {'field' : '" + folderField.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{501}, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)"Bob", (String)actual);
    }

    public void testQuestionmarkWildcardInTheEnd() throws Exception {
        ContactField field = ContactField.GIVEN_NAME;
        ContactField folderField = ContactField.FOLDER_ID;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['=' , {'field' : '" + field.getAjaxName() + "'} , 'Bo?'], " + "['=' , {'field' : '" + folderField.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{501}, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)"Bob", (String)actual);
    }

    public void testAsteriskWildcardInTheBeginning() throws Exception {
        ContactField field = ContactField.GIVEN_NAME;
        ContactField folderField = ContactField.FOLDER_ID;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['=' , {'field' : '" + field.getAjaxName() + "'} , '*b'], " + "['=' , {'field' : '" + folderField.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{501}, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)"Bob", (String)actual);
    }

    public void testAsteriskWildcardInTheEnd() throws Exception {
        ContactField field = ContactField.GIVEN_NAME;
        ContactField folderField = ContactField.FOLDER_ID;
        JSONObject filter = new JSONObject("{'filter' : [ 'and', ['=' , {'field' : '" + field.getAjaxName() + "'} , 'B*'], " + "['=' , {'field' : '" + folderField.getAjaxName() + "'}, " + this.folderID + "]" + "]})");
        AdvancedSearchRequest request = new AdvancedSearchRequest(filter, new int[]{501}, -1, null);
        CommonSearchResponse response = this.getClient().execute(request);
        AdvancedSearchTest.assertFalse((String)"Should work", (boolean)response.hasError());
        Object[][] resultTable = response.getArray();
        AdvancedSearchTest.assertNotNull((String)"Should find a result", (Object)resultTable);
        AdvancedSearchTest.assertEquals((String)"Should find one result", (int)1, (int)resultTable.length);
        int columnPos = response.getColumnPos(field.getNumber());
        String actual = (String)resultTable[0][columnPos];
        AdvancedSearchTest.assertEquals((String)"Bob", (String)actual);
    }
}

