/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.openexchange.ajax.writer.AttachmentWriter;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONWriter;

public class AttachmentWriterTest
extends TestCase {
    private static final List<AttachmentMetadata> DUMMY_VALUES = new ArrayList<AttachmentMetadata>();

    public void testWriteList() throws Exception {
        StringWriter result = new StringWriter();
        AttachmentWriter writer = new AttachmentWriter(new JSONWriter((Writer)new PrintWriter(result)));
        writer.writeAttachments((SearchIterator)new SearchIteratorAdapter(DUMMY_VALUES.iterator()), new AttachmentField[]{AttachmentField.ID_LITERAL, AttachmentField.FILENAME_LITERAL, AttachmentField.CREATION_DATE_LITERAL}, TimeZone.getTimeZone("utc"));
        JSONArray arrayOfarrays = new JSONArray(result.toString());
        for (int i = 0; i < arrayOfarrays.length(); ++i) {
            JSONArray array = arrayOfarrays.getJSONArray(i);
            AttachmentWriterTest.assertEquals((int)(10 + i), (int)array.getInt(0));
            AttachmentWriterTest.assertEquals((String)("test" + (i + 1) + ".txt"), (String)array.getString(1));
            AttachmentWriterTest.assertEquals((long)230023L, (long)array.getLong(2));
        }
    }

    public void testWriteObject() throws Exception {
        StringWriter result = new StringWriter();
        AttachmentWriter writer = new AttachmentWriter(new JSONWriter((Writer)new PrintWriter(result)));
        writer.write(DUMMY_VALUES.get(0), TimeZone.getTimeZone("utc"));
        JSONObject object = new JSONObject(result.toString());
        AttachmentWriterTest.assertEquals((int)1, (int)object.getInt(AttachmentField.ATTACHED_ID_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((int)2, (int)object.getInt(AttachmentField.CREATED_BY_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((int)3, (int)object.getInt(AttachmentField.FOLDER_ID_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((int)10, (int)object.getInt(AttachmentField.ID_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((int)23, (int)object.getInt(AttachmentField.MODULE_ID_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((int)12345, (int)object.getInt(AttachmentField.FILE_SIZE_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((int)230023, (int)object.getInt(AttachmentField.CREATION_DATE_LITERAL.toString()));
        AttachmentWriterTest.assertEquals((String)"text/plain", (String)object.getString(AttachmentField.FILE_MIMETYPE_LITERAL.getName()));
        AttachmentWriterTest.assertEquals((String)"test1.txt", (String)object.getString(AttachmentField.FILENAME_LITERAL.getName()));
        AttachmentWriterTest.assertTrue((boolean)object.getBoolean(AttachmentField.RTF_FLAG_LITERAL.getName()));
    }

    public void testTimeZone() throws Exception {
        StringWriter result = new StringWriter();
        AttachmentWriter writer = new AttachmentWriter(new JSONWriter((Writer)new PrintWriter(result)));
        writer.write(DUMMY_VALUES.get(0), TimeZone.getTimeZone("Europe/Berlin"));
        JSONObject object = new JSONObject(result.toString());
        AttachmentWriterTest.assertEquals((int)3830023, (int)object.getInt(AttachmentField.CREATION_DATE_LITERAL.toString()));
    }

    static {
        AttachmentImpl m = new AttachmentImpl();
        m.setAttachedId(1);
        m.setCreatedBy(2);
        m.setCreationDate(new Date(230023L));
        m.setFileMIMEType("text/plain");
        m.setFilename("test1.txt");
        m.setFilesize(12345L);
        m.setFolderId(3);
        m.setId(10);
        m.setModuleId(23);
        m.setRtfFlag(true);
        DUMMY_VALUES.add((AttachmentMetadata)m);
        m = new AttachmentImpl((AttachmentMetadata)m);
        m.setId(11);
        m.setFilename("test2.txt");
        DUMMY_VALUES.add((AttachmentMetadata)m);
        m = new AttachmentImpl((AttachmentMetadata)m);
        m.setId(12);
        m.setFilename("test3.txt");
    }
}

