/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.Expectations;

public class TestsForChangingAmongYearlyRecurrences
extends ManagedAppointmentTest {
    public TestsForChangingAmongYearlyRecurrences(String name) {
        super(name);
    }

    public void testShouldChangeFromYearly1ToYearly2() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        changes.put(214, (Object)1);
        changes.put(212, (Object)2);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldFailChangingFromYearly1ToYearly2UsingOnlyAdditionalData() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(212, (Object)2);
        this.negativeAssertionOnUpdate.check(app, changes, OXExceptionFactory.getInstance().create((OXExceptionCode)OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_INTERVAL));
    }

    public void testShouldChangeFromYearly2ToYearly1With127() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(212, (Object)127);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        changes.put(214, (Object)1);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldChangeFromYearly2ToYearly1WithNull() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(212, null);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        changes.put(214, (Object)1);
        Expectations expectations = new Expectations(changes);
        expectations.put(212, (Object)127);
        this.positiveAssertionOnCreateAndUpdate.check(app, changes, expectations);
    }

    public void testShouldFailChangingFromYearly2ToYearly1WhileMissingMonth() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(212, (Object)1);
        changes.put(215, (Object)1);
        changes.put(213, (Object)1);
        this.negativeAssertionOnUpdate.check(app, changes, OXCalendarExceptionCodes.RECURRING_MISSING_YEARLY_MONTH.create());
    }

    public void testShouldFailChangingFromYearly2ToYearly1UsingOnlyAdditionalData() throws Exception {
        Appointment app = this.generateYearlyAppointment();
        Changes changes = new Changes();
        changes.put(209, (Object)4);
        changes.put(212, (Object)127);
        this.negativeAssertionOnUpdate.check(app, changes, OXExceptionFactory.getInstance().create((OXExceptionCode)OXCalendarExceptionCodes.INCOMPLETE_REC_INFOS_INTERVAL));
    }
}

