/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.Test;
import org.xml.sax.SAXException;

public class Bug12212Test
extends AbstractAJAXSession {
    final String bugname = "Test for bug 12212";

    public Bug12212Test(String name) {
        super(name);
    }

    public Appointment createDailyRecurringAppointment(TimeZone timezone, int folderId) {
        Calendar calendar = TimeTools.createCalendar(timezone);
        Appointment series = new Appointment();
        series.setTitle("Test for bug 12212");
        series.setParentFolderID(folderId);
        series.setIgnoreConflicts(true);
        calendar.set(11, 12);
        series.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        series.setEndDate(calendar.getTime());
        series.setRecurrenceType(1);
        series.setInterval(1);
        series.setOccurrence(5);
        return series;
    }

    public void shiftAppointmentDateOneHour(Appointment appointment, TimeZone tz) {
        Calendar calendar = TimeTools.createCalendar(tz);
        calendar.setTime(appointment.getStartDate());
        calendar.add(10, 1);
        appointment.setStartDate(calendar.getTime());
        calendar.setTime(appointment.getEndDate());
        calendar.add(10, 1);
        appointment.setEndDate(calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMovingExceptionTwiceShouldNeitherCrashNorDuplicate() throws OXException, IOException, SAXException, JSONException, OXException {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateAppointmentFolder();
        TimeZone tz = client.getValues().getTimeZone();
        Appointment appointmentSeries = this.createDailyRecurringAppointment(tz, folderId);
        InsertRequest request = new InsertRequest(appointmentSeries, tz);
        CommonInsertResponse response = client.execute(request);
        appointmentSeries.setObjectID(response.getId());
        appointmentSeries.setLastModified(response.getTimestamp());
        try {
            int recurrence_position = 3;
            GetRequest request2 = new GetRequest(folderId, appointmentSeries.getObjectID(), 3);
            GetResponse response2 = client.execute(request2);
            Appointment occurrence = response2.getAppointment(tz);
            Appointment exception = new Appointment();
            exception.setObjectID(occurrence.getObjectID());
            exception.setParentFolderID(folderId);
            exception.setLastModified(occurrence.getLastModified());
            exception.setRecurrencePosition(occurrence.getRecurrencePosition());
            exception.setTitle(occurrence.getTitle() + "-changed");
            exception.setIgnoreConflicts(true);
            exception.setStartDate(occurrence.getStartDate());
            exception.setEndDate(occurrence.getEndDate());
            this.shiftAppointmentDateOneHour(exception, tz);
            AJAXRequest<UpdateResponse> request3 = new UpdateRequest(exception, tz);
            AbstractAJAXResponse response3 = client.execute(request3);
            int exceptionId = ((UpdateResponse)response3).getId();
            appointmentSeries.setLastModified(response3.getTimestamp());
            request3 = new GetRequest(folderId, exceptionId);
            response3 = (GetResponse)((Object)client.execute(request3));
            exception = ((GetResponse)response3).getAppointment(tz);
            this.shiftAppointmentDateOneHour(exception, tz);
            exception.setIgnoreConflicts(true);
            request3 = new UpdateRequest(exception, tz);
            response3 = client.execute(request3);
            exceptionId = ((UpdateResponse)response3).getId();
            appointmentSeries.setLastModified(response3.getTimestamp());
            request3 = new AllRequest(folderId, new int[]{200, 201, 202}, exception.getStartDate(), exception.getEndDate(), tz, false);
            response3 = (CommonAllResponse)((Object)client.execute(request3));
            Object[][] allAppointmentsWithinTimeframe = ((AbstractColumnsResponse)response3).getArray();
            int countOfPotentialDuplicates = 0;
            for (Object[] arr : allAppointmentsWithinTimeframe) {
                if (null == arr[0] || !((String)arr[0]).startsWith("Test for bug 12212")) continue;
                ++countOfPotentialDuplicates;
            }
            Bug12212Test.assertEquals((String)"Should be only one occurrence of this appointment", (Object)1, (Object)countOfPotentialDuplicates);
        }
        finally {
            GetRequest request4 = new GetRequest(folderId, appointmentSeries.getObjectID(), true);
            appointmentSeries.setLastModified(client.execute(request4).getTimestamp());
            DeleteRequest deleteRequest = new DeleteRequest(appointmentSeries);
            client.execute(deleteRequest);
        }
    }
}

