/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.List;
import org.junit.Test;

public class Bug29268Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private CalendarTestManager ctm;

    public Bug29268Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 29268 Test");
        Calendar start = TimeTools.createCalendar(this.client.getValues().getTimeZone());
        start.add(5, 1);
        start.set(11, 8);
        Calendar end = TimeTools.createCalendar(this.client.getValues().getTimeZone());
        end.add(5, 1);
        end.set(11, 9);
        this.appointment.setStartDate(start.getTime());
        this.appointment.setEndDate(end.getTime());
        this.appointment.setAlarm(0);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.ctm.insert(this.appointment);
    }

    @Test
    public void testBug29268() throws Exception {
        Appointment getAppointment = this.ctm.get(this.appointment);
        Bug29268Test.assertTrue((String)"Missing alarm value for get request.", (boolean)getAppointment.containsAlarm());
        Bug29268Test.assertEquals((String)"Wrong alarm value for get request.", (int)0, (int)getAppointment.getAlarm());
        ListIDs listIDs = new ListIDs(this.appointment.getParentFolderID(), this.appointment.getObjectID());
        List<Appointment> listAppointment = this.ctm.list(listIDs, new int[]{204});
        Bug29268Test.assertTrue((String)"Missing alarm value for list request.", (boolean)listAppointment.get(0).containsAlarm());
        Bug29268Test.assertEquals((String)"Wrong alarm value for list request.", (int)0, (int)listAppointment.get(0).getAlarm());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

