/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import org.json.JSONArray;

public class Bug16579Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private Appointment updateAppointment;

    public Bug16579Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 16579 Test");
        this.appointment.setStartDate(TimeTools.D("02.08.2010 08:00"));
        this.appointment.setEndDate(TimeTools.D("02.08.2010 09:00"));
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(2);
        this.appointment.setInterval(1);
        this.appointment.setUntil(TimeTools.D("23.08.2010 00:00"));
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.client.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.client.execute(request);
        insertResponse.fillObject((DataObject)this.appointment);
        this.updateAppointment = new Appointment();
        insertResponse.fillObject((DataObject)this.updateAppointment);
        this.updateAppointment.setParentFolderID(this.appointment.getParentFolderID());
        this.updateAppointment.setRecurrenceType(2);
        this.updateAppointment.setDays(2);
        this.updateAppointment.setInterval(1);
        this.updateAppointment.setUntil(TimeTools.D("20.09.2010 00:00"));
        this.updateAppointment.setIgnoreConflicts(true);
    }

    public void testBug16579() throws Exception {
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(this.updateAppointment, this.client.getValues().getTimeZone()));
        this.appointment.setLastModified(updateResponse.getTimestamp());
        int[] columns = new int[]{1, 201, 202};
        AllRequest allRequest = new AllRequest(this.client.getValues().getPrivateAppointmentFolder(), columns, TimeTools.D("01.09.2010 00:00"), TimeTools.D("01.10.2010 00:00"), this.client.getValues().getTimeZone(), false);
        CommonAllResponse allResponse = this.client.execute(allRequest);
        JSONArray json = (JSONArray)allResponse.getData();
        int count = 0;
        for (int i = 0; i < json.length(); ++i) {
            if (json.getJSONArray(i).getInt(0) != this.appointment.getObjectID()) continue;
            ++count;
        }
        Bug16579Test.assertEquals((String)"Wrong amount of occurrences", (int)3, (int)count);
    }

    @Override
    protected void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), this.appointment.getLastModified()));
        super.tearDown();
    }
}

